;
;                                 PCX-READ
;                                
; This is a demonstration how to depack a 256 color PCX-file.
; The main-routine is called 'depack_pcx' !
; You can use this piece of code freely.......
; This routine is made to depack pictures with a resolution of 320*200 pixel.
;
;                                                      Capella/Escape
;

ideal
model large
p386n
stack 256

assume cs:coding

segment  coding

start:        mov ax,pcxdata
              mov ds,ax
              assume ds:pcxdata
               
              mov ax,0a000h
              mov es,ax
              assume es:0a000h

              mov ax,0013h
              int 10h

;
;                        LOADROUTINE FOR THE PICTURE
;

              mov ax,3d02h
              mov dx,offset file
              int 21h
              jc error
              mov bx,ax

              mov ah,3fh
              mov dx,offset puffer
              mov cx,0ffffh
              int 21h
              jc error
              sub ax,768
              add ax,offset puffer
              mov [ds:bitmap_end],ax

              mov ah,3eh
              int 21h
              jc error

              call depack_pcx

              call set_colors
              
warte:        in al,60h
              cmp al,01h
              jne warte

              mov ax,0003h
              int 10h
              mov ax,4c00h
              int 21h

error:        mov ax,0003h
              int 10h
              mov dx,offset etxt
              mov ah,09h
              int 21h
              jmp warte

;
;                          THE PCX-DEPACK-ROUTINE
;

depack_pcx:   mov si,offset puffer
              add si,128
              xor di,di

depack_l2:    mov al,[ds:si]
              and al,11000000b
              cmp al,192
              jne single_byte
              
              mov cl,[ds:si]
              sub cl,192
              xor ch,ch

              mov al,[ds:si+1]
depack_l1:    mov [es:di],al
              inc di
              dec cx
              jnz depack_l1
              add si,2
              cmp si,[ds:bitmap_end]
              jb depack_l2

              ret

single_byte:  mov al,[ds:si]
              mov [es:di],al
              inc si
              inc di
              cmp si,[ds:bitmap_end]
              jb depack_l2
              ret

;
;                      SET THE COLORTABLE OF THE PCX FILE
;

set_colors:   mov si,[ds:bitmap_end]
        ;     inc si
              mov dx,03c8h
              xor al,al
              out dx,al
              inc dx
              mov cx,256
copy_colors:  mov al,[ds:si]
              shr al,2
              out dx,al
              mov al,[ds:si+1]
              shr al,2
              out dx,al
              mov al,[ds:si+2]
              shr al,2
              out dx,al
              add si,3
              dec cx
              jnz copy_colors
              ret


ends  coding

segment  pcxdata

file           db "testgfx.pcx",0
etxt           db "error appears.....$"
bitmap_end     dw ?

puffer         db 64000 dup (?)

ends  pcxdata

end start


