Unit Useful;
{Author   : Bjrn Appel
 Date     : 17.02.1996
 Version  : 1.1
 Language : TurboPascal v7.0

 This Unit is released to the public domain.
 It contains some "useful" routines.
 Send any comments, sugestions, ... to:

                        Bjrn Appel
                        Saalburgstr. 79
                        61130 Nidderau
                        Germany


}
INTERFACE


         {makes a sound of Freq Hz for Time ms}
         Procedure Beep(Freq, Time : Integer);

         Function  Hoch(Basis, Potenz : Real) : Real;

         {writes a string in screencenter and begin a new line}
         Procedure WriteMdlLn(S : String);

         {same like below, but without jumping in next line}
         Procedure WriteMdl(S : String);

         {works like UpCase, but for strings}
         Function  UpStr(S : String) : String;

         Function  Bin2Dec( Bin : String  ) : LongInt;
         Function  Bin2Hex( Bin : String  ) : String;
         Function  Dec2Bin( Dec : LongInt ) : String;
         Function  Dec2Hex( Dec : LongInt ) : String;
         Function  Hex2Bin( Hex : String  ) : String;
         Function  Hex2Dec( Hex : String  ) : LongInt;

         {sets the border of a VGA-Card}
         Procedure Border(Color : Byte);

         {converts a string into a number}
         Function Str2Dec(S : String) : LongInt;


         Function Null(S : String;Stellen : Byte) : String;

IMPLEMENTATION
Uses Crt, Dos;


Function Hoch(Basis, Potenz : Real) : Real;

   Begin
        Hoch:=Exp(Ln(Basis)*Potenz);
   End;


Procedure WriteMdlLn(s : String);
   Begin
        GotoXY( (80-Length(s))DIV 2,WhereY);
        WriteLn(S);
   End;


Procedure WriteMdl(s : String);
   Begin
        GotoXY( (80-Length(s))DIV 2,WhereY);
        Write(S);
   End;


Function UpStr(s : String) : String;
   Var St : String;
       I   : Byte;
   Begin
        St:='';
        For I:=1 TO Length(s) DO
        Begin
             St:=St+Upcase(s[I]);
        End;
        UpStr:=St;
   End;


Function Dec2Bin(Dec : LongInt) : String;
   Const B : Array[0 .. 1] of Char = ('0','1');
   Var   I : Word;
         Bin  : String;
         D :       LongInt;
   Begin
        Bin:='';
        Dec2Bin:='';
        D:=Dec;
        I:=0;
        Repeat
              I := D MOD 2;
              IF I=0 THEN Bin:= '0' + Bin
                     ELSE Bin:= '1' + Bin;
              D:=D DIV 2;
        until D=0;
        Dec2Bin:=Bin;
   End;


Function Hex2Dec(Hex : String) : LongInt;
   Const H   : Array[0..15] of Char =
         ('0','1','2','3','4','5','6','7','8','9','A','B','C','D','E','F');
   Var   I   : Word;
         Dec : LongInt;
         Ch  : Char;
         X   : Byte;
   Begin
         Dec:=0;
         FOR I := 0 TO Length(Hex)-1 DO
         Begin
              Ch  := UpCase( Hex[ Length(Hex)-I ] );
              CASE Ch OF
                   '0'  : X := 0;
                   '1'  : X := 1;
                   '2'  : X := 2;
                   '3'  : X := 3;
                   '4'  : X := 4;
                   '5'  : X := 5;
                   '6'  : X := 6;
                   '7'  : X := 7;
                   '8'  : X := 8;
                   '9'  : X := 9;
                   'A'  : X := 10;
                   'B'  : X := 11;
                   'C'  : X := 12;
                   'D'  : X := 13;
                   'E'  : X := 14;
                   'F'  : X := 15;
              End;
              Dec := Dec + Round(Hoch(16,I))*X;

         End;
         Hex2Dec:=Dec;
   End;


     Function Bin2Hex(Bin : String) : String;
     Begin
          Bin2Hex := Dec2Hex( Bin2Dec( Bin ) );
     End;


     Function Hex2Bin( Hex : String) : String;
     Begin
          Hex2Bin := Dec2Bin( Hex2Dec( Hex) );
     End;


     Function Dec2Hex(Dec:LongInt) : String;
        Var   H   : Byte;
              Hex : String;
              Hx  : Char;
              D   : LongInt;
        Begin
              D := Dec;
              Hex:='';
              Repeat
                    H := D MOD 16;
                    D := D DIV 16;
                    Case H of
                       0 : Hx:='0';
                       1 : Hx:='1';
                       2 : Hx:='2';
                       3 : Hx:='3';
                       4 : Hx:='4';
                       5 : Hx:='5';
                       6 : Hx:='6';
                       7 : Hx:='7';
                       8 : Hx:='8';
                       9 : Hx:='9';
                      10 : Hx:='A';
                      11 : Hx:='B';
                      12 : Hx:='C';
                      13 : Hx:='D';
                      14 : Hx:='E';
                      15 : Hx:='F';
                    End;
                    Hex:=Hx+Hex;
              until D=0;
              Dec2Hex:=Hex;
        End;


Function Bin2Dec(Bin : String) : LongInt;
   Var   I   : Word;
         Ch  : Char;
         Dec : LongInt;
         Bi  : String;
   Begin
        Bi := Bin;
        Dec := 0;
        FOR I := Length(Bi) DOWNTO 1 DO
        Begin
             IF Bi[I] = '1' THEN
             Begin
                  Dec := Dec + Round( Hoch( 2 , Length(Bi)-I ) );
             End;
        End;
        Bin2Dec:=Dec;
   End;


Function Str2Dec(S : String) : LongInt;
   Var   I    : Word;
         Ch   : Char;
         Temp : LongInt;
   Begin
        Temp:=0;
        FOR I:=0 TO Length(S) DO
        Begin
             Ch := S[Length(S)-I];
             CASE Ch OF
                  '0' : Temp := Temp + 0 * Round( Hoch(10,I) );
                  '1' : Temp := Temp + 1 * Round( Hoch(10,I) );
                  '2' : Temp := Temp + 2 * Round( Hoch(10,I) );
                  '3' : Temp := Temp + 3 * Round( Hoch(10,I) );
                  '4' : Temp := Temp + 4 * Round( Hoch(10,I) );
                  '5' : Temp := Temp + 5 * Round( Hoch(10,I) );
                  '6' : Temp := Temp + 6 * Round( Hoch(10,I) );
                  '7' : Temp := Temp + 7 * Round( Hoch(10,I) );
                  '8' : Temp := Temp + 8 * Round( Hoch(10,I) );
                  '9' : Temp := Temp + 9 * Round( Hoch(10,I) );
                  '-' : Temp :=-Temp;
             End;
        End;
        Str2Dec:=Temp;
   End;


     procedure BORDER (color : byte);
     var regs : registers;  (* Predeclared in the Dos unit *)
     begin
       FillChar (regs, SizeOf(regs), 0);  (* A precaution *)
       regs.ax := $0B00;    (* Service number *)
       regs.bh := $00;      (* Subservice number *)
       regs.bl := color;
       Intr ($10, regs);    (* ROM BIOS video driver interrupt *)
     end;  (* border *)


Function Null(S : String;Stellen : Byte) : String;
   Var Temp : String;
       St   : String;
       I    : Byte;
   Begin
        Temp := S;
        St   := S;
        IF Length(St)< Stellen Then
        Begin
             FOR I := 1 TO Stellen -Length(St) DO
             Begin
                  St:='0' + St;
             End;
        End;

        Null:=St;
   End;


   Procedure Beep(Freq, Time : Integer);
   Begin
        Sound(Freq);
        Delay(Time);
        NoSound;
   End;


END.