//
// DEMO.C
// Chtite demonstration d'utilisation du Linear Frame Buffer
// (c) EgoN Incorporated
//
// Dont Rip .. gna gna .. this code .. .. gna gna .. .. learn from it .....
//
// Personnellement j'men tamponne faites en ce que vous voulez !!!!! :)
//

#include <dos.h>

// pour la norme VESA 2.0 un LFB fait TOUJOURS 4 MEGS
#define lfbmemlimit ((4096 * 1024) - 1)

typedef unsigned short WORD;
typedef unsigned int DWORD;
typedef unsigned char BYTE;

typedef unsigned short word;
typedef unsigned int dword;
typedef unsigned char byte;

struct {
		char ID[4];           // Identification VESA
                BYTE VersionVESALo;   // No de version X.
                BYTE VersionVESAHi;   // No de version .X
		WORD LoFABRIC;        // adresse (Offset) du nom constructeur
		WORD HiFABRIC;        // adresse (Segment) du nom constructeur
                DWORD Flag;           // Flag non utilis
		WORD LoLIST;          // adresse (Offset) des modes SVGA disponibles
		WORD HiLIST;          // adresse (segment) des modes SVGA disponibles
		WORD Memoire;         // Nombres de segments de 64 Ko disponibles (VidRAM)
		WORD Flag2;           // Flag (????)
		WORD LoCARTE;         // adresse (Offset) du nom du CHIP Video
		WORD HiCARTE;         // adresse (Segement) du nom du CHIP Video
		WORD LoTCARTE;        // adresse (Offset) du nom de la carte
		WORD HiTCARTE;        // adresse (Segment) du nom de la carte
		BYTE Buffer[237];
} VESAInfo;

struct {
		WORD FlagMode;  // Flag du mode video concerne
		BYTE FlagW1;    // Flag de la premiere fenetre d'acces
		BYTE FlagW2;    // Flag de la deuxieme fenetre d'acces
		WORD Gran;      // Granularite en Ko
                WORD WTaille;   // Taille des deux fenetres d'acces
                WORD W1Seg;     // Segment de la premiere fenetre
                WORD W2Seg;     // Segment de la deuxieme fenetre
                DWORD Foncp;    // Offset de la fonction Bank switch
                WORD ByteRes;   // Nombre d'octets occups par une ligne de pts

                WORD XRes;      // Resolution en X pts/carac
                WORD YRes;      // Resolution en Y pts/carac
                BYTE XCar;      // Largeur caractere en pts
                BYTE YCar;      // Longueur caractere en pts
                BYTE NPlan;     // Nombre de plans de bits
                BYTE BPpix;     // Nombre de bits par pixels
                BYTE NBank;     // Nombre de bank memoire
                BYTE MModel;    // Modele memoire
                BYTE BTaille;   // Taille des banks memoires
                BYTE IPage;     // Nombre d'image page
                BYTE Reserve;   // Toujours  1

                // VBE 1.2 Extensions
                BYTE   RedMaskSize;
                BYTE   RedFieldPosition;
                BYTE   GreenMaskSize;
                BYTE   GreenFieldPosition;
                BYTE   BlueMaskSize;
                BYTE   BlueFieldPosition;
                BYTE   ReservedMaskSize;
                BYTE   ReservedFieldPosition;
                BYTE   DirectColourModeInfo;

                // VBE 2.0 Extentions
                DWORD  PhysBasePtr;
                DWORD  OffScreenMemOffset;
                WORD   OffScreenMemSize;
                BYTE   Reserved2[206];
            
} MODEInfo;

// pointeur FAR sur le LFB type 0x0000:0x00000000 (selecteur:offset)
byte far *lfb;

word ptrLFB(dword physAddr)
{
    // si ces variables sont en static c'est que certaines optimisations
    // du watcom ont tendances  tellement optimiser que les variables
    // n'existent QUE dans un registre-> Si vous la modifier avec de l'asm
    // boum la variable change.
    static word  sel;
    static dword linAddr;

    // alloue un selecteur
    sel = DPMIalloc();
    // map l'adresse physique    
    linAddr = DPMImap(physAddr, lfbmemlimit);
    // fixe la base et la limite
    DPMIsetselbase(sel, linAddr);
    DPMIsetsellimit(sel, lfbmemlimit);
    return(sel);
}


void main(void)
{
        int i,j;

        // Obtient les infos necessaires
        readVESA((char *)&VESAInfo);
        readINFO((char *)&MODEInfo,0x101);

        // Pas de VESA 2 ? 
        if(VESAInfo.VersionVESAHi<2)
        {
              // Hum ... changez de carte ..... :)
              printf("\nVesa version : %d.%d",VESAInfo.VersionVESAHi,VESAInfo.VersionVESALo);
              printf("\nLFB supporte uniquement avec VBE 2.0 !");
              printf("\nUtilisez un utilitaire VESA (UNIVBE)\n");
              exit(0);
        }

        // Cre le pointeur FAR sur le LFB
        lfb=MK_FP(ptrLFB(MODEInfo.PhysBasePtr),0);

        setVESA(0x4101);

        for(i=0;i<480;i++)
        {
          for(j=0;j<640;j++)
          {
//             *(lfb+(i*640)+j)=(byte)i%255;      // acces au LFB en C
             putpix(j,i,(byte)i%255);           // acces au LFB en ASM
          }
        }

        getch();

        Mode3();
}

