;
; GFXA.ASM
; Diverses fonctions pour gerer les modes VESA et fonctions DPMI
; (c) EgoN Incorporated
;
; Dont Rip .. gna gna .. this code .. .. gna gna .. .. learn from it .....
;
; Personnellement j'men tamponne faites en ce que vous voulez !!!!! :)
;
; A Propos: Le programme est compile avec l'option /3R
;           Les paramtres sont donc passs par les registres dans l'ordre :
;               1er  EAX
;               2eme EDX
;               3eme EBX
;               4eme ECX
;               5eme Pile
;               6eme Pile
;               7eme etc ...
;
; Le programme est loin d'tre complet. Si ca vous chante vous pouvez toujours
; inclure la gestion des erreurs ......
;
.386P

.model flat

        public Mode3_,putpix_
        public readVESA_,setVESA_,readINFO_
        public DPMIalloc_,DPMImap_,DPMIsetselbase_,DPMIsetsellimit_

.data

;structure pour l'appel d'interruption ou fonctions en mode reel
; cf voir int 31h fonction 0300h ou 0302h
; Respecter la taille et l'ordre des "Registres"
redi    dd ?
resi    dd ?
rebp    dd ?
reserv  dd ?
rebx    dd ?
redx    dd ?
recx    dd ?
reax    dd ?
flags   dw ?
res     dw ?
rds     dw ?
rfs     dw ?
rgs     dw ?
rip     dw ?
rcs     dw ?
rsp     dw ?
rss     dw ?
; Fin de la structure

; Slecteur utilis pour des allocations mmoire
sel     dw ?

; Selecteur qui va tre allou au LFB
lfbsel  dw ?

.code

;
; Lis les informations gnrales VESA: fonction 4F00h int 10h
; Attention cette fonction requiert un pointeur sur de la mmoire en mode
; rel. On va donc allouer un espace en mmoire Rel (<640k) et simuler
; une interruption en mode rel.
;
; Entre :
;       EAX = Pointeur sur la structure VESAInfo
; Sortie :
;       Nib
;
readVESA_ PROC

        push eax        ; sauvegarde l'adresse de la structure VESAINFO
        xor eax,eax     ; Int 31h fonction 0100h -> Allocate DOS memory block
        mov ax,0100h    
        mov bx,16d      ; Block de 256 octet 
        int 31h

        mov sel,dx      ; sauvegarde le selecteur alloue
        mov res,ax      ; sauvegarde le segment en memoire reel alloue
        mov edi,offset redi
        mov ax,0300h    ; int 31h fonction 0300h -> simulate Real mode int        
        mov bx,10h      ; Interruption 10h
        xor cx,cx
        mov redi,0      
        mov reax,4f00h  ; fonction 4F00h
        int 31h

        mov ax,res      ; recupere le segment en memoire rel
        shl eax,4       ; transforme le segment en adresse 32 bits
        mov esi,eax     ; le charge en ESI
        pop edi         ; EDI = adresse de la structure VESAInfo
        mov ecx,64d     ; 64*4 = copie de 256 octets 
        rep movsd       ; Zou

        mov ax,0101h    ; libere le selecteur alloue
        mov dx,sel      ; int 31h fonction 0101h -> Free DOS memory Block
        int 31h 

        ret
readVESA_ endp

;
; Lis les Informations d'un mode VESA: fonction 4F01h int 10h
; Attention cette fonction requiert un pointeur sur de la mmoire en mode
; rel. On va donc allouer un espace en mmoire Rel (<640k) et simuler
; une interruption en mode rel. (pareil que pour la fonction 4F00h)
;
; Entre :
;       EAX = Pointeur sur la structure MODEInfo
;       EDX = Mode VESA dont on dsire les informations
; Sortie :
;       Nib
;
readINFO_ proc

        push eax        ; sauvegarde l'adresse de la structure MODEInfo
        push edx        ; et le numero du mode  infotiser
        xor eax,eax     
        mov ax,0100h    ; Alloue un bloc en mmoire DOS de 256 octets
        mov bx,16d
        int 31h

        mov sel,dx      ; sauvegarde le selecteur alloue
        mov res,ax      ; sauvegarde le segment en mem reel alloue
        mov edi,offset redi
        pop recx
        mov ax,0300h
        mov bx,10h
        xor cx,cx
        mov redi,0
        mov reax,4f01h  ; Simule l'interruption 10h fonctions 4F01h
        int 31h

        mov ax,res
        shl eax,4       ; transforme le segment en adresse 32 bitssss
        mov esi,eax
        pop edi
        mov ecx,64d
        rep movsd       ; Copie les 256 octets dans notre structure MODEInfo

        mov ax,0101h    ; libere le block DOS alloue
        mov dx,sel
        int 31h

	ret

readINFO_ endp

;
; SetVESA : Fixe le mode VESA demand
; On peut appel l'interruption Directement
;
; Entre :
;       AX = Numero de mode VESA
; Sortie :
;       Nib
;
setVESA_ proc

        mov bx,ax
        mov ax,4f02h
        int 10h

        ret

setVESA_ endp

;
; DPMIalloc : Cre un nouveau slecteur et fixe des droits d'accs
;               droits : 8092h = Lecture / Ecriture sur ce segment
;
; Entre :
;       Nib
; Sortie :
;       AX = Selecteur cr
;
DPMIalloc_ proc

        xor eax,eax     
        mov cx,1        ; Fonction 1 int 31h -> Allocate Selector
        int 31h
        mov lfbsel,ax   ; Sauvegarde ce selecteur
        push ax
        mov bx,ax
        mov ax,9        ; Fonction 9 int 31h -> Set access Rights
        mov cx,8092h    ; Droits en lecture / ecriture
        int 31h
        pop ax

        ret

DPMIalloc_ endp

;
; DPMImap: Mappe une adresse physique dans l'espace mmoire adressable par
; le DOS extender. En effet si l'adresse physique du LFB est A0800000h
; il est impossible  DOS4GW de l'adresser (4 Go de RAM ca commence a faire)
; on reloge Donc cette mmoire  un endroit "adressable"
;
; Entre:
;       EAX = Adresse physique de la zone mmoire
;       EDX = Taille de cette zone
; Sortie:
;       EAX = Nouvelle adresse de la zone
;
DPMImap_ proc

        mov ebx,eax
        shr ebx,16      ; BX:CX = adresse de la zone
        mov cx,ax
        mov ax,0800h    ; fonction 0800h Map physical to linear memory
        mov esi,edx
        shr esi,16      ; SI:DI = taille du bloc
        mov di,dx
        int 31h
        mov ax,bx       ; BX:CX = nouvelle adresse
        shl eax,16      
        mov ax,cx       ; Reconstitue le tout dans EAX

        ret

DPMImap_ endp

;
; DPMIsetselbase : Fixe l'adresse de base de ce selecteur
;
; Entre :
;       AX  = Selecteur  modifier
;       EDX = Adresse de base  fixer pour ce selecteur
; Sortie :
;       Nib
;
DPMIsetselbase_ proc

        mov bx,ax       ; BX = selecteur
        mov ax,7        ; Fonction 7 -> Set segment Base adress
        mov ecx,edx     ; CX:DX = adresse de base
        shr ecx,16
        int 31h

        ret
DPMIsetselbase_ endp

;
; DPMIsetsellimit : Fixe la limite du segment
;
; Entre:
;       AX  = Selecteur du segment
;       EDX = Taille du segment en octets
; Sortie:
;       Nib
;
DPMIsetsellimit_ proc

        mov bx,ax       ; BX = selecteur du segment
        mov ecx,edx     
        shr ecx,16
        mov ax,8        ; CX:DX = Taille du segment
        int 31h

        ret
DPMIsetsellimit_ endp

;
; Mode3: devine ?
;
Mode3_ proc
        mov ax,3
        int 10h
        ret

Mode3_ endp

;
; Putpix : GnaGna Inside
;
; Entre:
;       EAX = X
;       EDX = Y
;       BL  = Couleur
;
putpix_ proc
        push es                 ; Sauvegarde ES

        mov edi,edx             ; offset = 640*Y + X
        shl edi,9               ; et bien sur 640*Y = 512*Y + 128*Y
        shl edx,7
        add edi,eax
        mov ax,lfbsel           ; charge le selecteur du LFB dans ES
        mov es,ax
        mov byte ptr es:[edi+edx],bl    ; Envoi l'octet

        pop es                  ; restaure ES
        ret
putpix_ endp

end

