Unit iCETxt;

interface

USES Crt;


CONST PelAddrRgR  = $3C7;
      PelAddrRgW  = $3C8;
      PelDataReg  = $3C9;

TYPE RGB = RECORD
       R, G, B : BYTE;
     END;

  ScreenRec=Record
   CurX,CurY:Byte;
  End;

  ScreenType=Array[1..4000] of Byte;

Var
  i : INTEGER;
  ch : CHAR;
  col : ARRAY[0..63] OF RGB;
  Screen   :Array[1..4] of ScreenType;  { acutal Screen data }
  Scr      :Array[1..4] of ScreenRec;   { corresponding cursor X,Y data }

Procedure FadeTextOut;
Procedure FadeTextIn;
Procedure SaveScreen(Num:Byte);
Procedure RestoreScreen(Num:Byte);

implementation

Procedure SaveScreen(Num:Byte);
Begin
  Scr[Num].CurX:=WhereX; Scr[Num].CurY:=WhereY;
  Move(Mem[$b800:0000],Screen[Num],4000);
End;

Procedure RestoreScreen(Num:Byte);
Begin
 Move(Screen[Num],Mem[$b800:0000],4000);
 GotoXy(Scr[Num].CurX,Scr[Num].CurY);
End;

PROCEDURE GetCol(C : BYTE; VAR R, G, B : BYTE);
BEGIN
   Port[PelAddrRgR] := C;
   R:= Port[PelDataReg];
   G := Port[PelDataReg];
   B := Port[PelDataReg];
END;

PROCEDURE SetCol(C, R, G, B : BYTE);
BEGIN
   Port[PelAddrRgW] := C;
   Port[PelDataReg] := R;
   Port[PelDataReg] := G;
   Port[PelDataReg] := B;
END;

PROCEDURE SetInten(b : BYTE);
VAR i : INTEGER; fr, fg, fb : BYTE;
BEGIN
   FOR i := 0 TO 63 DO
   BEGIN
      fr := col[i].r*b DIV 63;
      fg := col[i].g*b DIV 63;
      fb := col[i].b*b DIV 63;
      SetCol(i, fr, fg, fb);
   END;
END;

Procedure FadeTextOut;
BEGIN
   FOR i := 0 TO 63 DO GetCol(i, col[i].r, col[i].g, col[i].b);
   FOR i := 63 DOWNTO 0 DO
   BEGIN
     SetInten(i);
     Delay(15);
   END;
End;

Procedure FadeTextIn;
Begin
   FOR i := 0 TO 63 DO BEGIN SetInten(i); Delay(20); END;
End;
END.