;--==//>> DV8 Scroller #1 (v.1.0.1) by MiCRO^[[{TaS/NME} <<\\==--
;--==//>> ------------------------------------------------ <<\\==--
;--==//>> This will make my smallest, tightest, fastest,   <<\\==--
;--==//>> k-rad-n-est scroller, yet...                     <<\\==--

.286                                    ;allow 80286 code
.model small                            ;small memory model (.EXE)
.stack 256                              ;256-byte stack segment

VGA_SEG EQU     0A000h                  ;A000h=VGA Graphics Video Memory

.data                                   ;BEGIN data segment

;definition of the "DV8"... each number is a color out of 256 colors...
;NOTE: color #'s 0 & 1 will not be rotated (color 0 = 0,0,0 = black)

;3x16=48 x32=1536
;                                                               |                                                  |                                                             |
let_A   db        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0,  0,  0, 0, 0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0
        db        0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1,  1,  1,  1, 1, 0, 1,  1,  1,  1,  1,  1,  1,  1,  0,  0,  0,  0,  0,  0,  0,  0, 0
        db        0, 1,67,66,65,64,63,62,61,60,59,58,57,56, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1,111,111,111, 1, 0, 1,154,155,156,157,158,159,159,  1,  0,  0,  0,  0,  0,  0,  0, 0
        db        0, 1,67,66,65,64,63,62,61,60,59,58,57,56,55, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1,110,110,110, 1, 0, 1,154,155,156,157,158,159,160,161,  1,  0,  0,  0,  0,  0,  0, 0
        db        0, 1,67,66,65,64,63,62,61,60,59,58,57,56,55,54, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1,109,109,109, 1, 0, 1,154,155,156,157,158,159,161,162,163,  1,  0,  0,  0,  0,  0, 0
        db        0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,55,54,53,52, 1, 0, 0, 0, 0, 0, 0, 0, 1,108,108,108, 1, 0, 1,  1,  1,  1,  1,  1,  1,162,163,163,164,  1,  0,  0,  0,  0, 0
        db        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1,53,52,52,51, 1, 0, 0, 0, 0, 0, 0, 1,107,107,107, 1, 0, 0,  0,  0,  0,  1,  0,  0,  1,164,164,164,  1,  0,  0,  0,  0, 0
        db        0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1,51,51,51, 1, 0, 0, 0, 0, 0, 0, 1,106,106,106, 1, 0, 1,  1,  1,  1,  1,  0,  0,  1,165,165,165,  1,  0,  0,  0,  0, 0
        db        0, 1, 2, 2, 2, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1,50,50,50, 1, 0, 0, 0, 0, 0, 0, 1,105,105,105, 1, 0, 1,175,175,175,174,  1,  1,167,167,166,166,  1,  0,  0,  0,  0, 0
        db        0, 1, 3, 3, 3, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1,49,49,49, 1, 0, 0, 0, 0, 0, 0, 1,104,104,104, 1, 0, 0,  1,174,174,173,171,169,168,168,167,  1,  0,  0,  0,  0,  0, 0
        db        0, 1, 4, 4, 4, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1,48,48,48, 1, 0, 0, 0, 0, 0, 0, 1,103,103,103, 1, 0, 0,  0,  1,173,172,171,170,169,168,  1,  0,  0,  0,  0,  0,  0, 0
        db        0, 1, 5, 5, 5, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1,47,47,47, 1, 0, 0, 0, 0, 0, 0, 1,102,102,102, 1, 0, 0,  0,  0,  1,172,171,170,169,  1,  0,  0,  0,  0,  0,  0,  0, 0
        db        0, 1, 6, 6, 6, 1, 0, 1, 0, 0, 0, 0, 0, 0, 1,46,46,46, 1, 0, 0, 0, 0, 0, 0, 1,101,101,101, 1, 0, 0,  0,  0,  0,  1,  1,  1,  1,  0,  0,  0,  0,  0,  0,  0,  0, 0
        db        0, 1, 7, 7, 7, 1, 0, 1, 1, 0, 0, 0, 0, 0, 1,45,45,45, 1, 0, 0, 0, 0, 0, 0, 1,100,100,100, 1, 0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0
        db        0, 1, 8, 8, 8, 1, 0, 1,68, 1, 0, 0, 0, 0, 1,44,44,44, 1, 0, 0, 0, 0, 0, 0, 1, 99, 99, 99, 1, 0, 1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  1,  0,  0,  0,  0, 0
        db        0, 1, 9, 9, 9, 1, 0, 1,69,70, 1, 0, 0, 0, 1,43,43,43, 1, 0, 0, 0, 0, 0, 0, 1, 98, 98, 98, 1, 0, 1,153,152,151,150,149,148,147,146,145,144,143,  1,  0,  0,  0, 0
        db        0, 1,10,10,10, 1, 0, 1,70,71,72, 1, 0, 1,41,42,42, 1, 0, 0, 0, 0, 0, 0, 0, 1, 97, 97, 97, 1, 0, 1,153,152,151,150,149,148,147,146,145,144,143,142,  1,  0,  0, 0
        db        0, 1,11,11,11, 1, 0, 1,71,72, 1, 0, 0, 1,40,41,41, 1, 0, 0, 0, 0, 0, 0, 0, 1, 96, 96, 96, 1, 0, 1,153,152,151,150,149,148,147,146,145,143,142,141,140,  1,  0, 0
        db        0, 1,12,12,12, 1, 0, 0, 1,73, 1, 0, 1,38,39,40, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 95, 95, 95, 1, 0, 1,  1,  1,  1,  1,  1,  1,  1,  1,  1,142,141,140,139,138,  1, 0
        db        0, 1,13,13,13, 1, 0, 0, 0, 1, 0, 0, 1,37,38,39, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 94, 94, 94, 1, 0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,140,139,138,137,  1, 0
        db        0, 1,14,14,14, 1, 0, 0, 0, 0, 0, 1,35,36,37, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 93, 93, 93, 1, 0, 1,  1,  1,  1,  1,  0,  0,  0,  0,  0,  0,  1,137,137,137,  1, 0
        db        0, 1,15,15,15, 1, 0, 0, 0, 0, 0, 1,34,35,36, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 92, 92, 92, 1, 0, 1,112,112,112,  1,  0,  0,  0,  0,  0,  0,  1,136,136,136,  1, 0
        db        0, 1,16,16,16, 1, 0, 0, 0, 0, 1,32,33,34, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 91, 91, 91, 1, 0, 1,113,113,113,  1,  0,  0,  0,  0,  0,  0,  1,135,135,135,  1, 0
        db        0, 1,17,17,17, 1, 0, 0, 0, 0, 1,31,32,33, 1, 0, 1,73, 1, 0, 0, 0, 0, 0, 0, 1, 90, 90, 90, 1, 0, 1,114,114,114,  1,  0,  0,  0,  0,  0,  0,  1,134,134,134,  1, 0
        db        0, 1,18,18,18, 1, 0, 0, 0, 1,29,30,31, 1, 0, 0, 1,74,75, 1, 0, 0, 0, 0, 1,88, 89, 89, 89, 1, 0, 1,115,115,115,  1,  0,  0,  0,  0,  0,  0,  1,133,133,133,  1, 0
        db        0, 1,19,19,19, 1, 0, 0, 0, 1,28,29,30, 1, 0, 1,74,75,76,77, 1, 0, 0, 1,86,87, 88, 88,  1, 0, 0, 1,115,116,117,118,  1,  0,  0,  0,  0,  1,130,131,132,132,  1, 0
        db        0, 1,20,20,20, 1, 0, 1, 1,26,27,28, 1, 0, 0, 0, 1,76,77,78,79, 1, 1,84,85,86, 87,  1,  0, 0, 0, 1,116,117,118,119,120,  1,  1,  1,  1,128,129,130,131,131,  1, 0
        db        0, 1,21,21,21, 1, 0, 1,24,25,26,27, 1, 0, 0, 0, 0, 1,78,79,80,81,82,83,84,85,  1,  0,  0, 0, 0, 0,  1,118,119,120,121,122,123,124,125,127,128,129,130,  1,  0, 0
        db        0, 1,22,22,22, 1, 0, 1,24,25,25, 1, 0, 0, 0, 0, 0, 0, 1,79,80,81,82,83,84, 1,  0,  0,  0, 0, 0, 0,  0,  1,120,120,121,122,123,124,125,126,127,128,  1,  0,  0, 0
        db        0, 1,23,23,23, 1, 0, 1,23,24,25, 1, 0, 0, 0, 0, 0, 0, 0, 1,80,81,82,83, 1, 0,  0,  0,  0, 0, 0, 0,  0,  0,  1,121,121,122,123,124,125,125,126,  1,  0,  0,  0, 0
        db        0, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0,  0,  0,  0, 0, 0, 0,  0,  0,  0,  1,  1,  1,  1,  1,  1,  1,  1,  0,  0,  0,  0, 0
        db        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,  0,  0,  0, 0, 0, 0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 0


;length and width of "DV8" defined
a_width         db      48
a_length        db      32

;current x & y positions, beginning at (0,0)
x_pos           dw      0
y_pos           dw      0
x_pos2          dw      49;310-48
y_pos2          dw      33;190-32
x_pos3          dw      99;160
y_pos3          dw      67;90

;begin in direction 1, where:
;  direction 1 = down, right
;  direction 2 = up, right
;  direction 3 = up, left
;  direction 4 = down, left
direction       db      1
directionb      db      1;3
directionc      db      1;4

;used for rotation of palette
temp            db      3 DUP (?)
pal             db      768 DUP (?)

credit          db      'DV8 Scroller #1 (ver.1.0.1) By MiCRO^[[{TaS/NME}',13,10
                db      'DV8  [713] 480-5901 (NodE 1)',13,10
                db      '     [713]          (NodE 2)',13,10
                db      'TragiK aNSi SpinnerZ = FREE ART!!',13,10,'$'

.code                                   ;BEGIN code segment

;clear the screen, set mode to 13h (320x200x256 VGA Graphics Mode)
        mov     ax,0013h                ;ROM-BIOS Service 00h (set mode) (al=13)
        int     10h                     ;perform interrupt (video services)

;copy pre-defined values for palette
        mov     cx,768                  ;256 colors * 3 bytes/color (r,g, & b)
        mov     ax,@code                ;
        mov     ds,ax                   ;
        mov     si,offset palarr        ;copy from palarr in CS
        mov     ax,@data                ;
        mov     es,ax                   ;
        mov     di,offset pal           ;copy to pal in DS
        rep     movsb                   ;copy the palette bytes...

        mov     si, offset pal          ;address our variable palette
        call    setpal                  ;set the palette using pal

        mov     ax,@data                ;the letter 'A' is in DS
        mov     ds,ax                   ;

        mov     ax,VGA_SEG              ;address the video memory
        mov     es,ax                   ;assign it to ES (extra seg)

        mov     si,0                    ;beginning of letter data
        mov     di,0                    ;beginning of video memory

;wait for any key (loop until keypressed)
keywait:
        mov     dx,3DAh
holdon:
        in      al,dx
        test    al,08h
        jz      holdon
retrace:
        in      al,dx
        test    al,08h
        jz      retrace

;display the cyber-letter 'A'
nextpixel:
        movsb
        dec     [a_width]               ;next byte in line
        jnz     nextpixel               ;have we drawn a line?
nextline:
        mov     [a_width],48            ;reset count for next line
        add     di,320-48               ;adjust video memory pointer
        dec     [a_length]              ;next line in letter
        jnz     nextpixel               ;have we drawn the letter?

        mov     si,0                    ;reset to start of letter A
        mov     ax,[y_pos2]             ;linear location = 320*y_pos + x_pos
        mov     bx,320
        mul     bx
        add     ax,[x_pos2]
        mov     di,ax
        mov     [a_length],32
nextpixel2:
        movsb
        dec     [a_width]              ;next byte in line
        jnz     nextpixel2              ;have we drawn a line?
nextline2:
        mov     [a_width],48           ;reset count for next line
        add     di,320-48               ;adjust video memory pointer
        dec     [a_length]             ;next line in letter
        jnz     nextpixel2              ;have we drawn the letter?

        mov     si,0                    ;reset to start of letter A
        mov     ax,[y_pos3]             ;linear location = 320*y_pos + x_pos
        mov     bx,320
        mul     bx
        add     ax,[x_pos3]
        mov     di,ax
        mov     [a_length],32

nextpixel3:
        movsb
        dec     [a_width]              ;next byte in line
        jnz     nextpixel3              ;have we drawn a line?
nextline3:
        mov     [a_width],48           ;reset count for next line
        add     di,320-48               ;adjust video memory pointer
        dec     [a_length]             ;next line in letter
        jnz     nextpixel3              ;have we drawn the letter?

;determine current direction and jump to appropriate section
        cmp     [direction],1
        je      direction1
        cmp     [direction],2
        je      direction2
        cmp     [direction],3
        je      direction3
        jmp     direction4              ;none of these?  then must be 4
check_direction2:
        cmp     [directionb],1
        je      j_d1b;direction1b
        cmp     [directionb],2
        je      j_d2b;direction2b
        cmp     [directionb],3
        je      j_d3b;direction3b
        jmp     direction4b             ;none of these?  then must be 4

j_d1b:                                  ; fuck.... too far 2 jump conditionally
        jmp     direction1b
j_d2b:
        jmp     direction2b
j_d3b:
        jmp     direction3b

check_direction3:
        cmp     [directionc],1
        je      j_d1c;direction1c
        cmp     [directionc],2
        je      j_d2c;direction2c
        cmp     [directionc],3
        je      j_d3c;direction3c
        jmp     direction4c             ;none of these?  then must be 4

j_d1c:                                  ; fuck.... too far 2 jump conditionally
        jmp     direction1c
j_d2c:
        jmp     direction2c
j_d3c:
        jmp     direction3c

;the following is neccesary because for every direction, there are two
;different boundries, and therefore two different reactions (new directions)
direction1:
        inc     [x_pos]                 ;move down one
        inc     [y_pos]                 ;move right one
        cmp     [x_pos],320-48          ;have we reached the boundry?
        je      dir_4                   ;yes? then new direction is needed
        cmp     [y_pos],200-32          ;ditto?
        je      dir_2                   ;you get the picture...
        jmp     done_direction          ;passed, remain in current direction
direction2:
        inc     [x_pos]                 ;move down one
        dec     [y_pos]                 ;move left one
        jz      dir_1                   ;boundry?
        cmp     [x_pos],320-48          ;etc, etc, etc...
        je      dir_3
        jmp     done_direction
direction3:
        dec     [x_pos]
        jz      dir_2
        dec     [y_pos]
        jz      dir_4
        jmp     done_direction
direction4:
        dec     [x_pos]
        jz      dir_1
        inc     [y_pos]
        cmp     [y_pos],200-32
        je      dir_3
        jmp     done_direction

;assign new directions, if needed...
dir_1:
        mov     [direction],1
        jmp     done_direction
dir_2:
        mov     [direction],2
        jmp     done_direction
dir_3:
        mov     [direction],3
        jmp     done_direction
dir_4:
        mov     [direction],4
        jmp     done_direction

direction1b:
        inc     [x_pos2]                ;move down one
        inc     [y_pos2]                ;move right one
        cmp     [x_pos2],320-48         ;have we reached the boundry?
        je      dir_4b                  ;yes? then new direction is needed
        cmp     [y_pos2],200-32         ;ditto?
        je      dir_2b                  ;you get the picture...
        jmp     done_direction2         ;passed, remain in current direction
direction2b:
        inc     [x_pos2]                ;move down one
        dec     [y_pos2]                ;move left one
        jz      dir_1b                  ;boundry?
        cmp     [x_pos2],320-48         ;etc, etc, etc...
        je      dir_3b
        jmp     done_direction2
direction3b:
        dec     [x_pos2]
        jz      dir_2b
        dec     [y_pos2]
        jz      dir_4b
        jmp     done_direction2
direction4b:
        dec     [x_pos2]
        jz      dir_1b
        inc     [y_pos2]
        cmp     [y_pos2],200-32
        je      dir_3b
        jmp     done_direction2

;assign new directions, if needed...
dir_1b:
        mov     [directionb],1
        jmp     done_direction2
dir_2b:
        mov     [directionb],2
        jmp     done_direction2
dir_3b:
        mov     [directionb],3
        jmp     done_direction2
dir_4b:
        mov     [directionb],4
        jmp     done_direction2

direction1c:
        inc     [x_pos3]                ;move down one
        inc     [y_pos3]                ;move right one
        cmp     [x_pos3],320-48         ;have we reached the boundry?
        je      dir_4c                  ;yes? then new direction is needed
        cmp     [y_pos3],200-32         ;ditto?
        je      dir_2c                  ;you get the picture...
        jmp     done_direction3         ;passed, remain in current direction
direction2c:
        inc     [x_pos3]                ;move down one
        dec     [y_pos3]                ;move left one
        jz      dir_1c                  ;boundry?
        cmp     [x_pos3],320-48         ;etc, etc, etc...
        je      dir_3c
        jmp     done_direction3
direction3c:
        dec     [x_pos3]
        jz      dir_2c
        dec     [y_pos3]
        jz      dir_4c
        jmp     done_direction3
direction4c:
        dec     [x_pos3]
        jz      dir_1c
        inc     [y_pos3]
        cmp     [y_pos3],200-32
        je      dir_3c
        jmp     done_direction3

;assign new directions, if needed...
dir_1c:
        mov     [directionc],1
        jmp     done_direction3
dir_2c:
        mov     [directionc],2
        jmp     done_direction3
dir_3c:
        mov     [directionc],3
        jmp     done_direction3
dir_4c:
        mov     [directionc],4
        jmp     done_direction3

;we have finished messing with the direction, rotate palette, then move
done_direction:
        jmp     check_direction2
done_direction2:
        jmp     check_direction3
done_direction3:
        call    rotpal
        mov     si,offset pal+6         ;why 6?  skip colors 0 & 1
        call    setpal

        mov     si,0                    ;reset to start of letter A
        mov     ax,[y_pos]              ;linear location = 320*y_pos + x_pos
        mov     bx,320
        mul     bx
        add     ax,[x_pos]
        mov     di,ax
        mov     [a_length],32

;in the future, i will use the quicker "out" with 60h, looking for ESC only...
        mov     ah,1                    ;ROM-BIOS Service 01h (key ready?)
        int     16h                     ;perform interrupt (keyboard services)
        jnz     keypressed              ;keywait is >127 bytes away... must
        jmp     keywait                 ;  unconditionally jump
keypressed:
        xor     ah,ah                   ;ROM-BIOS Service 00k (read key)
        int     16h                     ;perform interrupt (keyboard services)

;clear the screen, reset mode to text 80x25x16
        xor     ah,ah                   ;ROM-BIOS Service 00h (set mode)
        mov     al,3                    ;mode 3 = text 80x25x16
        int     10h                     ;perform interrupt (video services)

        mov     dx,offset credit
        mov     ah,9
        int     21h

        mov     ah,04Ch                 ;DOS Sub-routine 4Ch (DOS exit program)
        int     21h                     ;perform interrupt

setpal  PROC    near
        mov     cx,768-6                ;skip first two colors, done manually
        mov     al,0                    ;0=set palette
setcx:  mov     dx,3C8h                 ;VGA port
        out     dx,al
        inc     dx                      ;VGA port, palette data
        ;cld
        out     dx,al                   ;color #0=0,0,0
        out     dx,al
        out     dx,al
        out     dx,al                   ;color #1=0,89,55 (bluish color)
        mov     al,89
        out     dx,al
        mov     al,55
        out     dx,al
        rep     outsb                   ;send the rest of the color definitions
        ret
setpal  ENDP

rotpal  PROC    near
;first, save the first color into temp...
        mov     bx,3
        mov     cx,3
loopone:mov     al,[bx+byte ptr pal]
        mov     [temp+bx-3],al
        inc     bx
        loop    loopone
;now, rotate the rest, covering up the first...
        mov     cx,768-6
        mov     bx,6
again:  mov     al,[bx+byte ptr pal]
        mov     [bx+byte ptr pal-3],al
        inc     bx
        loop    again
;last, restore the saved color to the last position in the palette...
        mov     bx,768-3
        mov     cx,3
looptwo:mov     al,[bx+temp-765]
        mov     [bx+byte ptr pal],al
        inc     bx
        loop    looptwo
        ret
rotpal  ENDP

palarr:
;REMEMBER: every color has a RED value, a GREEN value, and a BLUE value...
;  --==//>> 256 colorZ * 3 bytes per color (R,G,& B) = 768 bytes <<\\==--
;   R  G  B    R  G  B    R  G  B    R  G  B...
db  0, 0, 0,   0,89,55,   0,89,55,   0,80,49,   0,71,43,   0, 6,36,   0, 0, 0
db  0, 0, 0,   0, 0, 0,   0, 0, 0,   0, 0, 0,   0, 0, 0,   0, 0, 0,   0, 0, 0
db  0, 0, 0,   0, 0, 0,   0, 0, 0,   0,61,61,   0,52,52,   0,44,44,   0,40,40
db  0, 0, 0,   0, 0, 0,   0, 0, 0,   0, 0, 0,   0, 0, 0,   0, 0, 0,   0,89,55
db  0,80,49,   0,71,43,   0, 6,36,   0, 0, 0,   0, 0, 0,   0, 0, 0,   0, 0, 0
db  0, 0, 0,   0, 0, 0,   0, 0, 0,   0,61,61,   0,52,52,   0,44,44,   0,40,40
db  0, 0, 0,   0, 0, 0,   0, 0, 0,   0, 0, 0,   0, 0, 0,   0, 0, 0,   0,89,55
db  0,80,49,   0,71,43,   0, 6,36,   0, 0, 0,   0, 0, 0,   0, 0, 0,   0, 0, 0
db  0, 0, 0,   0, 0, 0,   0, 0, 0,   0,61,61,   0,52,52,   0,44,44,   0,40,40
db  0, 0, 0,   0, 0, 0,   0, 0, 0,   0, 0, 0,   0, 0, 0,   0, 0, 0,   0,89,55
db  0,80,49,   0,71,43,   0, 6,36,   0, 0, 0,   0, 0, 0,   0, 0, 0,   0, 0, 0
db  0, 0, 0,   0, 0, 0,   0, 0, 0,   0,61,61,   0,52,52,   0,44,44,   0,40,40
db  0, 0, 0,   0, 0, 0,   0, 0, 0,   0, 0, 0,   0, 0, 0,   0, 0, 0,   0,89,55
db  0,80,49,   0,71,43,   0, 6,36,   0, 0, 0,   0, 0, 0,   0, 0, 0,   0, 0, 0
db  0, 0, 0,   0, 0, 0,   0, 0, 0,   0,61,61,   0,52,52,   0,44,44,   0,40,40
db  0, 0, 0,   0, 0, 0,   0, 0, 0,   0, 0, 0,   0, 0, 0,   0, 0, 0,   0,89,55
db  0,80,49,   0,71,43,   0, 6,36,   0, 0, 0,   0, 0, 0,   0, 0, 0,   0, 0, 0
db  0, 0, 0,   0, 0, 0,   0, 0, 0,   0,61,61,   0,52,52,   0,44,44,   0,40,40
db  0, 0, 0,   0, 0, 0,   0, 0, 0,   0, 0, 0,   0, 0, 0,   0, 0, 0,   0,89,55
db  0,80,49,   0,71,43,   0, 6,36,   0, 0, 0,   0, 0, 0,   0, 0, 0,   0, 0, 0
db  0, 0, 0,   0, 0, 0,   0, 0, 0,   0,61,61,   0,52,52,   0,44,44,   0,40,40
db  0, 0, 0,   0, 0, 0,   0, 0, 0,   0, 0, 0,   0, 0, 0,   0, 0, 0,   0,89,55
db  0,80,49,   0,71,43,   0, 6,36,   0, 0, 0,   0, 0, 0,   0, 0, 0,   0, 0, 0
db  0, 0, 0,   0, 0, 0,   0, 0, 0,   0,61,61,   0,52,52,   0,44,44,   0,40,40
db  0, 0, 0,   0, 0, 0,   0, 0, 0,   0, 0, 0,   0, 0, 0,   0, 0, 0,   0,89,55
db  0,80,49,   0,71,43,   0, 6,36,   0, 0, 0,   0, 0, 0,   0, 0, 0,   0, 0, 0
db  0, 0, 0,   0, 0, 0,   0, 0, 0,   0,61,61,   0,52,52,   0,44,44,   0,40,40
db  0, 0, 0,   0, 0, 0,   0, 0, 0,   0, 0, 0,   0, 0, 0,   0, 0, 0,   0,89,55
db  0,80,49,   0,71,43,   0, 6,36,   0, 0, 0,   0, 0, 0,   0, 0, 0,   0, 0, 0
db  0, 0, 0,   0, 0, 0,   0, 0, 0,   0,61,61,   0,52,52,   0,44,44,   0,40,40
db  0, 0, 0,   0, 0, 0,   0, 0, 0,   0, 0, 0,   0, 0, 0,   0, 0, 0,   0,89,55
db  0,80,49,   0,71,43,   0, 6,36,   0, 0, 0,   0, 0, 0,   0, 0, 0,   0, 0, 0
db  0, 0, 0,   0, 0, 0,   0, 0, 0,   0,61,61,   0,52,52,   0,44,44,   0,40,40
db  0, 0, 0,   0, 0, 0,   0, 0, 0,   0, 0, 0,   0, 0, 0,   0, 0, 0,   0,89,55
db  0,80,49,   0,71,43,   0, 6,36,   0, 0, 0,   0, 0, 0,   0, 0, 0,   0, 0, 0
db  0, 0, 0,   0, 0, 0,   0, 0, 0,   0,61,61,   0,52,52,   0,44,44,   0,40,40
db  0, 0, 0,   0, 0, 0,   0, 0, 0,   0, 0, 0

END