{ Lightbar demo! }
Uses XDoor, XMisc;


Function LightBar: Byte;
 Const
    numChoices = 4;                   { number of choices in lightbar      }
    Choice     : array [1..numChoices] of String[40] =
                 ('    choice 1    ',
                  '    choice 2    ',
                  '    choice 3    ',
                  '    choice 4    ');
    txtColor   = 8;                   { color of choice when NOT selected  }
    barFG      = 9;                   { foreground color for WHEN selected }
    barBG      = 1;                   { background color for WHEN selected }

 Var
    Cur: Byte;
      I: Byte;
     Ch: Char;

 Procedure Up;
  Begin
   restoreCursor;
   fg(txtColor);
   bg(0);
   out(choice[cur]);
   if cur = 1 then Begin
    cur := numChoices;
    restorecursor;
    posDown(pred(numChoices)); 
    End Else Begin
     Dec(Cur);
     restorecursor;
     posUp(1);
     End;
   saveCursor;
   color(barFG,barBG);
   cout(choice[cur]);
  End;


 Procedure Down;
  Begin
   restoreCursor;
   fg(txtColor);
   bg(0);
   out(choice[cur]);
   if cur = numChoices then Begin
    cur := 1;
    restorecursor;
    posUp(pred(numChoices)); 
    End Else Begin
     Inc(Cur);
     restorecursor;
     posDown(1);
     End;
   saveCursor;
   color(barFG,barBG);
   cout(choice[cur]);
  End;

  Begin
   cur := 1;
   saveCursor;
   color(barFg,barBg);
   cout(choice[1]);
   color(txtcolor,0);
    for I := 2 to numChoices Do Begin
     restoreCursor;
     posDown(1);
     saveCursor;
     cout(choice[i]);
     End;
   restoreCursor;
   posUp(pred(numChoices));       
   savecursor;
   posRight(length(choice[1]));
          Repeat
           ch := inKey;
           if hitUp then up;      { if local or remote pressed up arrow }
           if hitDown then down;  { if local or remote pressed down key }
          Until (Ch = #13);  { until they press <ENTER> }
      bg(0);
   lightbar := cur;
  End; { end lightbar proc }


var
  choice: byte;

Begin
 doorName := '% lightbar demo %';
 initdoor;
 choice := lightbar;
 cGotoxy(1,7);
 coutln('|07Y|15ou picked choice #'+itos(choice));
 nl;
 pause;
End.
