# -----(Description)----------------------------------------------------------
# Telnet BBS Guide to Mystic BBS Importer v1.0 By Darryl Perry, 2004.  
# A Cyberia BBS Production, Released through the Warlock Modding Group.
#
# Telnet BBS Guide to Mystic BBS (MWF) is a script that will import the BBS 
# listings from the Telnet BBS Guide into the native Mystic BBS bbslist.
#
# Although this program is entered into the public domain, please give 
# credit where credit is due.  If you use this program, or portions thereof,
# please give due credit.
#
# More information can be found in the sysop.txt file of the tbg2bbi1.zip file
# ----------------------------------------------------------------------------
Uses CFG

Var Ch1		Char
Var F1		String
Var F2		String
Var I1		Integer
Var RecCnt	Integer
Var Textl	String
Var B1		Boolean

Var bbs_cType		Byte
Var bbs_Phone		String
Var bbs_Telnet		String
Var bbs_Name		String
Var bbs_Location	String
Var bbs_Sysop		String
Var	bbs_Baud		String
Var bbs_Software	String
Var bbs_Deleted		Boolean
Var bbs_AddedBy		String
Var bbs_Verified	LongInt
Var bbs_Extra1		LongInt
Var bbs_Extra2		Integer

Function Del(St1 string, idx1 integer, len1 integer) : String
Begin
	If PathChar = '/' Then
		Delete(St1,Idx1,Len1)
	Else
		Delete(St1,Len1,Idx1)
	Endif
	Del:=St1
Pend

Procedure SaveBBSEntry
Begin
	if fexist(F2)	Then
		fOpen(2,bin,Append,F2)
	Else
		fOpen(2,Bin,ReWrite,F2)
	Endif
	
	fWriteRec (2, bbs_cType)
	fWriteRec (2, bbs_Phone, 15)
	fWriteRec (2, bbs_Telnet, 40)
	fWriteRec (2, bbs_Name, 30)
	fWriteRec (2, bbs_Location, 25)
	fWriteRec (2, bbs_Sysop, 30)
	fWriteRec (2, bbs_Baud, 6)
	fWriteRec (2, bbs_Software, 10)
	fWriteRec (2, bbs_Deleted)
	fWriteRec (2, bbs_AddedBy, 30)
	fWriteRec (2, bbs_Verified)
	fWriteRec (2, bbs_Extra1)
	fWriteRec (2, bbs_Extra2)

	fClose(2)
Pend

Procedure ReadGuide
Var FoundFlg	Integer
Var FldCnt		Integer
Begin
	RecCnt:=1
	fOpen(1,Text,ReSet,F1)
	Repeat
		fReadLn(1,Textl)
		if pos('========',Textl) > 0 or pos('-------',Textl) > 0 Then	
			If RecCnt>3 Then
				WriteLn(PadRt(bbs_Name,30,' ') + PadRt(bbs_Telnet,30,' ') + bbs_Software)
#				WriteLn(bbs_Phone + ' ' + bbs_Location + ' ' + bbs_Sysop)
#				Write('.')
				SaveBBSEntry
			Endif
			FldCnt:=1
			RecCnt:=RecCnt+1
		Endif
		If FldCnt=3 Then
			bbs_Name:=textl
			if Pos(' ',bbs_Name) = 1 Then
				bbs_Name:=Del(bbs_Name,1,1)
			Endif
			if Pos('* ',bbs_Name) = 1 Then
				bbs_Name:=Del(bbs_Name,2,1)
			Endif
		Endif
		If Pos('  Telnet:',Textl)	> 0 Then
			bbs_Telnet:=Textl
			bbs_Telnet:=Del(bbs_Telnet,10,1)
			I1:=Pos(' ',bbs_Telnet)
			if I1 > 0 then
				bbs_Telnet:=Del(bbs_Telnet,Length(bbs_Telnet),I1)
			Endif
		Endif
		If Pos('Software:',Textl)	> 0 Then
			bbs_Software:=textl
			bbs_Software:=Del(bbs_Software,10,1)
			I1:=Pos('Total Nodes:',bbs_Software)
			If I1 > 0 Then
				bbs_Software:=Del(bbs_Software,Length(bbs_Software),I1)
			Endif
		Endif
		If Pos('Dial-Up:',Textl)	> 0 Then
			bbs_Phone:=textl
			bbs_Phone:=Del(bbs_Phone,10,1)
		Endif
		bbs_cType:=2
		bbs_Baud:='56k'
		If Pos('Telnet Only',bbs_Phone) > 0 Then
			bbs_cType:=1
		Endif
		If Pos('Location:',Textl)	> 0 Then
			bbs_Location:=textl
			bbs_Location:=Del(bbs_Location,10,1)
		Endif
		If Pos('Email:',Textl)	> 0 Then
			bbs_Sysop:=textl
			bbs_Sysop:=Del(bbs_Sysop,10,1)
		Endif
		bbs_AddedBy:='Telnet BBS Guide'
		bbs_Verified:=DateTime
		bbs_Deleted:=False
		FldCnt:=FldCnt+1
	Until eof(1) 
	fClose(1)
	WriteLn(Int2Str(RecCnt)+' records created.|CR|PA')
Pend

Begin
	GetCfg
	If ParamCount < 1 Then
		WriteLn('|CRUsage: tbg2bbi <bbslist filename>|CR|PA')
		halt
	Else
		F2:=CfgDataPath+ParamStr(1)+'.bbi'
	Endif
	WriteLn('|CR|11Path and filename of The (Full) Telnet BBS Guide.')
	WriteLn('i.e. /home/bbs/temp/telf0903.txt')
	WriteLn(' or \bbs\temp\telf0903.txt')
	Write(':')	
	F1:=Input(75,75,11,'')
	If not fexist(f1) Then
		WriteLn('Telnet BBS Guide File not found|CR|PA')
		halt
	Endif
	WriteLn('|CR|12Warning!')
	WriteLn('|11This will destroy all data in "'+paramstr(1)+'.bbi"!')
	If InputYN('Continue? ') Then
		If fExist(F2) Then
			fErase(F2)
		Endif
		ReadGuide
	Endif
End
