//ਬ   ": BLUR"

#include <conio.h>

unsigned char screen[64000];
unsigned char buffer[64000];
long screen_ptr=(long)&screen;
long buffer_ptr=(long)&buffer;

void setgrmode(char x);
void setrgbpalette(char color, char r, char g, char b);
void setcolortable();
void trueblurscreen();
void fastblurscreen();
void fillscreen();
void clearvirtualscreen();
void clearbufferscreen();
void copyvirtualscreen();
void copybufferscreen();

main()
{
  setgrmode(0x13);
  setcolortable();
  clearvirtualscreen();
  clearbufferscreen();
  fillscreen();
  while(!kbhit())
  {
    trueblurscreen();
    copybufferscreen();
    copyvirtualscreen();
  }
  getch();
  fillscreen();
  while(!kbhit())
  {
    fastblurscreen();
    copyvirtualscreen();
  }
  setgrmode(0x3);
  getch();
}

void setgrmode(char x)
{
  _asm
  {
    xor ax,ax
    mov al,x
    int 10h
  }
}

void setrgbpalette(char color, char r, char g, char b)
{
  _asm
  {
    mov dx,0x3C8
    mov al,color
    out dx,al
    inc dx
    mov al,r
    out dx,al
    mov al,g
    out dx,al
    mov al,b
    out dx,al
  }
}


void fillscreen()
{
  long ptr=screen_ptr+321;
  for(short y=1;y<199;y++)
  {
    for(short x=1;x<319;x++)
    {
      *((char*)ptr)=255;
      ptr++;
    }
    ptr+=2;
  }
}

void copyvirtualscreen()
{
  _asm
  {
    mov dx,3DAh
  a:in al,dx
    test al,8
    jnz a
    mov dx,3DAh
  b:in al,dx
    test al,8
    jz b
    cld
    mov edi,0xA0000
    mov esi,screen_ptr
    mov ecx,16000
    rep movsd
  }
}

void copybufferscreen()
{
  _asm
  {
    cld
    mov edi,screen_ptr
    mov esi,buffer_ptr
    mov ecx,16000
    rep movsd
  }
}

void clearvirtualscreen()
{
  _asm
  {
    cld
    mov ecx,16000
    mov edi,screen_ptr
    mov eax,0x00000000
    rep stosd
  }
}

void clearbufferscreen()
{
  _asm
  {
    cld
    mov ecx,16000
    mov edi,buffer_ptr
    mov eax,0x00000000
    rep stosd
  }
}

void setcolortable()
{
  for(short k=0;k<=63;k++)
  {
    setrgbpalette(k,k,0,0);
    setrgbpalette(k+64,63,k,0);
    setrgbpalette(k+128,63,63,k);
    setrgbpalette(k+192,63,63,63);
  }
}

void trueblurscreen()
{
  long ptr_scr=screen_ptr+321;
  long ptr_buf=buffer_ptr+321;
  for(short y=1;y<199;y++)
  {
    for(short x=1;x<319;x++)
    {
      *((char*)ptr_buf)=(*((char*)(ptr_scr-321))+*((char*)(ptr_scr-320))+
                         *((char*)(ptr_scr-319))+*((char*)(ptr_scr-1))+
                         *((char*)(ptr_scr+1))+*((char*)(ptr_scr+319))+
                         *((char*)(ptr_scr+320))+*((char*)(ptr_scr+321)))>>3;
      ptr_scr++;
      ptr_buf++;
    }
    ptr_scr+=2;
    ptr_buf+=2;
  }
}

void fastblurscreen()
{
  long ptr_scr=screen_ptr+321;
  for(short y=1;y<199;y++)
  {
    for(short x=1;x<319;x++)
    {
      *((char*)ptr_scr)=(*((char*)(ptr_scr-320))+*((char*)(ptr_scr-1))+
                         *((char*)(ptr_scr+1))+*((char*)(ptr_scr+320)))>>2;
      ptr_scr++;
    }
    ptr_scr+=2;
  }
}