{--------------------------------------------------------------------------}
{ Loesung der Aufgabenstellung aus MiCo96                                  }
{                                                                          }
{ Zur Loesungsstrategie: Ich gehe von der Drittel-Logik aus.               }
{                        Vom eingegebenen bzw. verbliebenen Haufen lege    }
{                        ich je ein aufgerundetes Drittel auf die linke    }
{                        und die rechte Waagschale, den Rest lege ich      }
{                        zur weiteren Verwendung auf die Seite.            }
{                                                                          }
{                        Dann wird gewogen!                                }
{                                                                          }
{                        Waren beide Waagschalen gleich schwer, so         }
{                        werden alle Muenzen von den Waagschalen weggelegt }
{                        und mit den restlichen Muenzen wird weitergewogen.}
{                        War ein Waagschale leichter, so werden deren      }
{                        Muenzen weiterverarbeitet und die Muenzen des     }
{                        gemerkten Rests und der anderen Waagschale        }
{                        weggelegt. Pro Wiegvorgang wird der Rest so       }
{                        auf ca. 1/3 reduziert.                            }
{                                                                          }
{ (c) 1996 by Lichtschwert (Klaus Babl). Erstellt mit Borland Pascal 7.0   }
{--------------------------------------------------------------------------}

Program Wiegen;

{Units}

Uses CRT;                         {wegen ClrScr ...}

{Variablen}

var   Muenzen  : Integer;         {Anzahl der zu wiegenden Muenzen (Eingabe)}
      Rest     : Integer;         {Rest der zu wiegenden Muenzen}
      Drittel  : Integer;         {Aufgerundetes Drittel vom Muenzenrest}
      Wiegzahl : Integer;         {Anzahl Wiegevorgaenge}

const NoLeft   : String = 'Muenze(n) von linker  Waagschale bitte weglegen!';
      NoRight  : String = 'Muenze(n) von rechter Waagschale bitte weglegen!';
      NoRest   : String = 'Nicht gewogene Muenze(n) bitte weglegen!';
      TakeLeft : String = 'Muenze(n) von linker  Waagschale weiterverarbeiten!';
      TakeRight: String = 'Muenze(n) von rechter Waagschale weiterverarbeiten!';
      TakeRest : String = 'Aufbewahrten Rest weiterverarbeiten!';
      ZuWiegen : String = ' Muenze(n) auf linke und rechte Waagschale legen!';
      Aufheben : String = ' Muenze(n) als Rest aufheben!';
      IsRest   : String = 'Aufbewahrte Muenze ist Faelschung!';
      Abort    : String = 'Programm wurde abgebrochen';
      ProgText : String = 'Das Muenzen-Wiegeprogramm';
      ULine    : String = '=========================';
      AbortText: String = 'A = Abbruch';
      Zahltext : String = 'Anzahl Muenzen (Zahl zwischen 1 und 100 eingeben):';
      FrageEQ  : String = 'Sind die Schalen gleich schwer? (JA/NEIN)';
      FrageLeft: String = 'Ist die linke Schale schwerer?  (JA/NEIN)';
      EndeText1: String = 'Danke fuer die Benutzung dieses Programmes ...';
      EndeText2: String = '... und moege die Macht mit Euch sein!';
      EnterKey : String = 'Danach beliebige Taste druecken!';

{Anzahl der Muenzen ermitteln}

procedure GetAnzahl;
var   Anzahl  : Integer;           {Muenzenanzahl: Hilfsfeld fuer VAL-Funktion}
      ValCode : Integer;           {Fehlercode:    Hilfsfeld fuer VAL-Funktion}
const Eingabe : String = '';
begin
      Muenzen := 0;                       {Initialwert}

      While  Muenzen = 0 DO               {Schleife: nachlesen Muenzenanzahl}
      begin
             ClrScr;                      {Bildschirm loeschen}
             WriteLn(ProgText);           {Programm-Ueberschrift}
             WriteLn(ULine);              {Unterstrich}
             WriteLn('');                 {Leerzeile}
             WriteLn(AbortText);          {Abbruch-Hinweis}
             WriteLn('');                 {Leerzeile}
             WriteLn(ZahlText);           {Eingabeaufforderung}
             WriteLn('');                 {Leerzeile}
             ReadLn(Eingabe);             {Eingabe lesen}

             If ( Eingabe = 'A' ) OR ( Eingabe = 'a' ) then
             begin
                    Rest := -1;           {fuer Abbruchmeldung im Hauptprog.}
                    Break;                {Schleife verlassen}
             end;

             Val(Eingabe, Anzahl, ValCode); {Eingabe numerisch aufbereiten}

             {Gueltige Eingabe}

             If  ( Valcode = 0 ) And ( Anzahl  > 0 ) And ( Anzahl  < 101) then
             begin
                   Muenzen := Anzahl;     {Gueltige Anzahl}
                   Rest    := Muenzen;    {zu wiegender Rest}
             end;
      end;

end;

{Wiegevorgang mit Ausgabe}

procedure Wiege;
var   Eingabe,                           {String fuer Tastatureingabe}
      SMuenzen,
      SRest,
      SWiegeNeu,
      SWiegzahl : String;                {Strings fuer Ausgabe}
      Laufzahl,                          {Zaehler fuer FOR-Schleife}
      WiegeNeu,                          {neues Wiegedrittel -> aufgerundet)}
      RestNeu   : Integer;               {neues Restdrittel  -> abgerundet)}
      Okay      : Boolean;               {gueltige Eingabe verlangen}

begin
      Okay    := false;                  {Initialwert}
      Eingabe := '';                     {Initialwert}

      WriteLn('');                       {Leerzeile}

      {Naechste Wiegung: Die Addition des Restes mit 2 bewirkt die Ermittlung
       des aufgerundeten ganzzahligen Drittelanteils! Ausnahme: Rest 1.
       Dann ist die Muenze die letzte verbliebene und damit die LOESUNG!}

      If Rest > 1 then
      begin
            WiegeNeu := ( Rest + 2 ) DIV 3;
            RestNeu  := Rest - ( 2 * WiegeNeu );
      end;

      {String fuer Anweisungen aufbereiten!}

      Str(Muenzen, SMuenzen);            {als String aufbereiten}
      Str(Rest, SRest);                  {als String aufbereiten}
      Str(WiegeNeu, SWiegeNeu);          {als String aufbereiten}
      Str(Wiegzahl, SWiegzahl);          {als String aufbereiten}

      {Rest 1: LOESUNG ausgeben}

      If Rest = 1 then begin
           ClrScr;                                        {Bildschirm loeschen}
           WriteLn(ProgText);                             {Programm-Ueberschrift}
           WriteLn(ULine);                                {Unterstrich}
           WriteLn('');                                   {Leerzeile}
           WriteLn('Anzahl Muenzen gesamt : ' + SMuenzen);  {gesamte Anzahl}
           WriteLn('Noch im Rennen       : ' + SRest);    {verbliebene Muenzen}
           WriteLn('Anzahl Wiegevorgaenge: ' + SWiegzahl);{bisherige Wiegungen}
           WriteLn('');                                   {Leerzeile}
           WriteLn(IsRest);                               {Ergebnis}
           WriteLn('');                                   {Leerzeile}
           WriteLn(EndeText1);                            {Abschiedsmeldung}
           WriteLn(EndeText2);                            {Abschiedsmeldung}
           Rest := 0;                                     {Wiegeschleife beenden}
           Exit;                                          {Routine verlassen}
      end;

      {1. Abfrage: sind beide Waagschalen gleich. Dies darf natuerlich nicht
       mehr gefragt werden, wenn der uebrige Rest 0 ist. Dann muessen sie
       naemlich ungleich sein!
       Gueltige Antworten sind JA, NEIN und A fuer Abbruch!}

      While ( NOT Okay ) AND  ( RestNeu > 0 ) DO
      begin
            ClrScr;                      {Bildschirm loeschen}
            WriteLn(ProgText);           {Programm-Ueberschrift}
            WriteLn(ULine);              {Unterstrich}
            WriteLn('');                 {Leerzeile}
            WriteLn('Anzahl Muenzen gesamt: ' + SMuenzen); {gesamte Anzahl}
            WriteLn('Noch im Rennen       : ' + SRest);    {verbliebene Muenzen}
            WriteLn('Anzahl Wiegevorgaenge: ' + SWiegzahl);{bisherige Wiegungen}
            WriteLn('');                                   {Leerzeile}

            {neue Eingaben verlangen}

            WriteLn('Je ' + SWiegeNeu + ZuWiegen);         {Waage fuellen}
            WriteLn('');                                   {Leerzeile}
            WriteLn(AbortText);                            {Abbruch-Hinweis}
            WriteLn('');                                   {Leerzeile}
            WriteLn(FrageEQ);                              {gleich schwer?}
            WriteLn('');                                   {Leerzeile}
            ReadLn(Eingabe);                               {Eingabe lesen!}

            For Laufzahl := 1 TO Length(Eingabe) DO        {->Grossbuchstaben}
                Eingabe[Laufzahl] := UpCase(Eingabe[Laufzahl]);

            If  Eingabe = 'A'     then    {Abbruch}
            begin
                  Rest := -1;             {Abbruchmeldung}
                  Okay := true;           {gueltige Eingabe, beendet Schleife}
            end;

            If  Eingabe = 'JA'    then
            begin
                  WriteLn('');            {Leerzeile}
                  WriteLn(NoLeft);        {Linke Schale weglegen}
                  WriteLn(NoRight);       {rechte Schale weglegen}
                  WriteLn(TakeRest);      {Restdrittel weiter untersuchen}
                  WriteLn(EnterKey);      {Anweisung: Taste druecken}
                  WriteLn('');            {Leerzeile}
                  ReadKey;                {auf Bestaetigung warten}
                  Okay := true;           {gueltige Eingabe, beendet Schleife}
                  Rest := Rest - 2 * WiegeNeu; {Rest reduzieren}
                  Inc(Wiegzahl);          {Wiegezahl erhoehen}
            end;

            If  Eingabe = 'NEIN'  then
            begin
                  Break;                  {gueltig, raus aus Schleife
                                           aber noch nicht okay}
            end;

      end;

      {2. Abfrage: ist linke Waagschale schwerer? Dies darf natuerlich nicht
       mehr gefragt werden, wenn beide gleich schwer waren oder bei Abbruch
       (OKAY = True in beiden Faellen!)!
       Gueltige Antworten sind JA, NEIN und A fuer Abbruch!}

      If NOT Okay then
      begin
            If RestNeu = 0 then begin       {Ausgabe erforderlich}
               ClrScr;                      {Bildschirm loeschen}
               WriteLn(ProgText);           {Programm-Ueberschrift}
               WriteLn(ULine);              {Unterstrich}
               WriteLn('');                 {Leerzeile}
               WriteLn('Anzahl Muenzen gesamt: ' + SMuenzen); {gesamte Anzahl}
               WriteLn('Noch im Rennen       : ' + SRest);    {verbliebene Muenzen}
               WriteLn('Anzahl Wiegevorgaenge: ' + SWiegzahl);{bisherige Wiegungen}
               WriteLn('');                                   {Leerzeile}

               {neue Eingaben verlangen}

               WriteLn('Je ' + SWiegeNeu + ZuWiegen);         {Waage fuellen}
               WriteLn('');                                   {Leerzeile}
               WriteLn(AbortText);                            {Abbruch-Hinweis}
               WriteLn('');                                   {Leerzeile}
            end;

            WriteLn('');                                   {Leerzeile}
            WriteLn(FrageLeft);                            {links schwerer?}
            WriteLn('');                                   {Leerzeile}
      end;

      {Anmerkung: ich weiss leider noch nicht, wie ich hier bei Falscheingabe
       hier wieder eine Zeile hochkomme, deshalb sind die WriteLn-Zeilen
       vorangestellt!}

      While ( NOT Okay ) DO
      begin
            ReadLn(Eingabe);                               {Eingabe lesen!}

            For Laufzahl := 1 TO Length(Eingabe) DO        {->Grossbuchstaben}
                Eingabe[Laufzahl] := UpCase(Eingabe[Laufzahl]);

            If  Eingabe = 'A'     then    {Abbruch}
            begin
                  Rest := -1;             {Abbruchmeldung}
                  Okay := true;           {gueltige Eingabe, raus aus Schleife}
            end;

            If  Eingabe = 'JA'    then
            begin
                  WriteLn('');            {Leerzeile}
                  WriteLn(NoLeft);        {Linke Schale weglegen}
                  WriteLn(NoRest);        {Rest weglegen}
                  WriteLn(TakeRight);     {rechte Schale weiter untersuchen}
                  WriteLn(EnterKey);      {Anweisung: Taste druecken}
                  WriteLn('');            {Leerzeile}
                  ReadKey;                {auf Bestaetigung warten}
                  Okay := true;           {gueltige Eingabe, raus aus Schleife}
                  Rest := Rest - WiegeNeu - RestNeu; {Rest reduzieren}
                  Inc(Wiegzahl);          {Wiegezahl erhoehen}
            end;

            If  Eingabe = 'NEIN'  then
            begin
                  WriteLn('');            {Leerzeile}
                  WriteLn(NoRight);       {Rechte Schale weglegen}
                  WriteLn(NoRest);        {Rest weglegen}
                  WriteLn(TakeLeft);      {linke Schale weiter untersuchen}
                  WriteLn(EnterKey);      {Anweisung: Taste druecken}
                  WriteLn('');            {Leerzeile}
                  ReadKey;                {auf Bestaetigung warten}
                  Okay := true;           {gueltige Eingabe, raus aus Schleife}
                  Rest := Rest - WiegeNeu - RestNeu; {Rest reduzieren}
                  Inc(Wiegzahl);          {Wiegezahl erhoehen}
           end;

      end;

end;

{Hauptprogramm}

begin

      {Initialisierung und Anzahl der moeglichen Muenzen ermitteln}

      GetAnzahl;

      { Verarbeitung }

      If Muenzen > 0 then                 {Gueltige Muenzenanzahl eingegeben}
         While Rest > 0 Do  Wiege;        {naechster Wiegevorgang}

      If Rest = -1 then
      begin
            ClrScr;
            WriteLn(Abort);               {Abbruchmeldung}
      end;
end.