#include <windows.h>
#include <GL/glu.h>
#include <GL/gl.h>
#include <math.h>
#include "bouncer.h"
#include "globals.h"


Bouncer::Bouncer (GLfloat bounceHeight, GLfloat XV, GLfloat ZV)
{
	xv = XV;
	zv = ZV;
	currentX = 0;
	currentY = bounceHeight;
	currentZ = 0;
	direction = false;
	setHeight (bounceHeight);
	sY = sX = sZ = 0.01f;
}

void Bouncer::setHeight (GLfloat bounceHeight)
{
	height = bounceHeight;
	falltime = (GLfloat)(sqrt (2*(height-0.1)/9.82));
}

void Bouncer::start ()
{
	startTime = time;
}

void Bouncer::move ()
{
	GLfloat delta = time - lastTime;
	if (!direction)
		currentY = (GLfloat)(height - (9.82*(time-startTime)*(time-startTime)*0.5));
	else
		currentY = (GLfloat)(height - (9.82*(falltime-(time-startTime))*(falltime-(time-startTime))*0.5));

	if (currentY < 0.1)
	{
		direction = !direction;
		currentY = 0.1f;
		startTime = time;
	}
	if (direction && (time-startTime) > falltime)
	{
		direction = !direction;
		currentY = height;
		startTime = time;
	}

	sY = 0.01f;
	// deformation
	if (currentY < 1)
	{
		sY = currentY * 0.01f;
		sX = (2-currentY) * 0.01f;
		sZ = (2-currentY) * 0.01f;
	}
	else
	{
		sY = ((currentY - 1) / (height - 1)) * 0.002f + 0.01f;
		sX = 0.01f;
		sZ = 0.01f;
	}

	currentX += xv * delta;
	if (currentX < -9.9f)
	{
		currentX = -9.9f;
		xv = -xv;
	}
	else if (currentX > 9.9f)
	{
		currentX = 9.9f;
		xv = -xv;
	}

	currentZ += zv * delta;
	if (currentZ < -9.9f)
	{
		currentZ = -9.9f;
		zv = -zv;
	}
	else if (currentZ > 9.9f)
	{
		currentZ = 9.9f;
		zv = -zv;
	}

	if (abs(currentZ) > 9.0f)
	{
		sZ = (10.0-abs(currentZ)) * 0.01f;
	}

	lastTime = time;
}
