#include <windows.h>
#include <stdio.h>
#include <math.h>
#include <GL/gl.h>
#include <GL/glu.h>
#include "atglib.h"			//Ile's crappy texgen lib I use because korona uses it
#include "text.h"
#include "system.h"
#include "globals.h"
#include "keys.h"
#include "sound.h"
// demo fx included below
#include "esher.h"
#include "cubes.h"
#include "waves.h"
#include "twirl.h"
#include "tunnel.h"
#include "blob.h"
#include "bounce.h"
#include "terrain.h"
#include "temple.h"
#include "golden.h"
#include "intro.h"
#include "scroller.h"


#define		CLASSNAME	"OpenGL"
#define		WINDOWNAME	"Shaven Raven"


int currchoice = 0, pois = 0;

char *button_names[8] = 
     {
     "640x480 (default)", 	
     "800x600", 	
     "960x720", 	
     "1024x768",
	 "1152x864",
     "1280x960",
	 "1280x1024",
	 "windowed"
     }; 


//------------------------------------------------------------------>
// Function		:	DoRedraw
// Description	:	Called by WndProc whenever it's time to redraw.
//------------------------------------------------------------------>
int DoRedraw(HDC *hDC)
{
	static	GLfloat starttime = 0.0f;

	if (starttime == 0.0f)
		starttime = GetTickCount () * 0.001f;

	order	= FMUSIC_GetOrder	(mod);
	row		= FMUSIC_GetRow		(mod);
	mtime	= order + (float)(row * 0.01);

	time = GetTickCount () * 0.001f - starttime;

	if (demostate == 1)
	{
		glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	
		switch (part)
		{
		case 0:
			part_Intro ();
			break;
		case 1:
			part_Wavepart ();
			break;
		case 2:
			part_Cubepart ();
			break;
		case 3:
			part_Tunnelpart ();
			break;
		case 4:
			part_Blobpart ();
			break;
		case 5:
			part_Bouncepart ();
			break;
		case 6:
			part_Terrainpart ();
			break;
		case 7:
			part_Esherpart ();
			break;
		case 8:
			part_Templepart ();
			break;
		case 9:
			part_Goldenpart ();
			break;
		default:
			break;
		}

           
		if (mtime >= 18.30)
			{ DeInit (); return 1; }
		else if (mtime > 16.00)
			part = 9;
		else if (mtime > 11.63)
			part = 8;
		else if (mtime > 10.00)
			part = 6;
		else if (mtime > 9.00)
			part = 5;
		else if (mtime > 7.00)
			part = 4;
		else if (mtime > 3.63)
			part = 3;
		else if (mtime > 2.33)
			part = 2;
		else if (mtime > 0.63)
			part = 1;
		else
			part = 0;


		if (mtime < 1.0 && time > 60.0) 
			{ DeInit (); return 1; }

		if (part > 7)
		{
			glColor4f (1.0f, 1.0f, 1.0f, 1.0f);
			DrawScrollText ();
		}

		//part = 8;

/*		glColor4f (1.0f, 1.0f, 1.0f, 1.0f);
		glText2D (_gcvt (time, 4, ctemp), 0.02, 0.02, 0.3);
		glText2D (_gcvt (mtime, 4, ctemp), 0.02, 0.06, 0.3);	*/
	}

	EndFrame (hDC);

return 0;
}

LRESULT APIENTRY WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	static	UINT timer;

	switch (message)
	{
		case WM_CREATE:
			timer = SetTimer (hWnd, 1, 20, NULL);
			return 0;
		case WM_DESTROY:
			ChangeDisplaySettings (NULL, 0);
			wglMakeCurrent (NULL, NULL);
			wglDeleteContext (hGLRC);
			KillTimer(hWnd, timer);
			PostQuitMessage(0);
			return 0;
		case WM_SIZE:
			if (hGLRC)
			{
				XRES = (int) LOWORD(lParam);
				YRES = (int) HIWORD(lParam);
				Resize();
				return 0;
			}
		case WM_PAINT:
			if (hGLRC)
			{
				PAINTSTRUCT ps;
				BeginPaint(hWnd, &ps);
				if (DoRedraw(&hDC) == 1)
					SendMessage(hWnd, WM_DESTROY, 0,0);
				EndPaint(hWnd, &ps);
				return 0;
			}
			break;

		case WM_TIMER:
			InvalidateRect (hWnd, NULL, FALSE);
			return 0;

		case WM_CHAR:
			switch ((int)wParam) 
			{
				case VK_ESCAPE:
					DeInit ();
					DestroyWindow(hWnd);

					return 0;
					break;
				default:
					break;
			}
			break;
		default:
			break;
	 }

	return DefWindowProc(hWnd, message, wParam, lParam);
}


LRESULT CALLBACK ChoiceWindowProc(HWND hwnd, 
						    UINT msg, 
                            WPARAM wparam, 
                            LPARAM lparam)
{
// this is the main message handler of the system
//PAINTSTRUCT		ps;		// used in WM_PAINT
//HDC				hdc;	// handle to a device context

// what is the message 
switch(msg)
	{	
	
	case WM_COMMAND:
		{
        if (LOWORD(wparam) == 100)
			{
			PostMessage(hwnd,WM_CLOSE,0,0);
			pois = 1;
			if (currchoice==0) currchoice = 1;
			}

		else if (LOWORD(wparam) < 109)
			currchoice = LOWORD(wparam)-100;
		}

	case WM_DESTROY:
		{
		//pois = 1;
		}

	default:break;

    } // end switch

// process any messages that we didn't take care of 
return (DefWindowProc(hwnd, msg, wparam, lparam));

} // end WinProc

int APIENTRY WinMain(HINSTANCE hCurrentInst, HINSTANCE hPreviousInst, LPSTR lpszCmdLine, int nCmdShow)
{
	WNDCLASS wndClass;
	WNDCLASSEX winclass;

	HWND hWnd, hwnd1, hwnd2;
	MSG msg;
	HDC hdc;

	hdc = GetDC(NULL);	
	oldXRES = GetDeviceCaps(hdc, HORZRES);
	oldYRES = GetDeviceCaps(hdc, VERTRES);

	wndClass.style = CS_HREDRAW | CS_VREDRAW | CS_OWNDC;
	wndClass.lpfnWndProc = WndProc;
	wndClass.cbClsExtra = 0;
	wndClass.cbWndExtra = 0;
	wndClass.hInstance = hCurrentInst;
	wndClass.hIcon = LoadIcon(NULL, IDI_APPLICATION);
	wndClass.hCursor = LoadCursor(NULL, IDC_ARROW);
	wndClass.hbrBackground = NULL;
	wndClass.lpszMenuName = NULL;
	wndClass.lpszClassName = CLASSNAME;
	RegisterClass(&wndClass);

	winclass.cbSize         = sizeof(WNDCLASSEX);
	winclass.style			= CS_DBLCLKS | CS_OWNDC | 
                          CS_HREDRAW | CS_VREDRAW;
	winclass.lpfnWndProc	= ChoiceWindowProc;
	winclass.cbClsExtra		= 0;
	winclass.cbWndExtra		= 0;
	winclass.hInstance		= hCurrentInst;
	winclass.hIcon			= LoadIcon(NULL, IDI_APPLICATION);
	winclass.hCursor		= LoadCursor(NULL, IDC_ARROW);
	winclass.hbrBackground	= (HBRUSH)(1);
	winclass.lpszMenuName	= NULL;
	winclass.lpszClassName	= "CHOICE_RESO";
	winclass.hIconSm        = LoadIcon(NULL, IDI_APPLICATION);
	RegisterClassEx(&winclass);

	// create the window
	if (!(hwnd1 = CreateWindowEx(NULL, // extended style
                            "CHOICE_RESO",   // class
						    "Make your choice", // title
						    /*WS_TABSTOP |*/ WS_VISIBLE /*| WS_SYSMENU*/ ,
					 	    250,200,	    // initial x,y
						    167,295,  // initial width, height
						    NULL,	    // handle to parent 
						    NULL,	    // handle to menu
						    hCurrentInst,// instance of this application
						    NULL)))	// extra creation parms
	return(0);

	if (!(hwnd2 = CreateWindowEx(NULL, // extended style
                            "button",   // class
						    "RUN", // title
							WS_CHILD | WS_VISIBLE,
					 	    10,210,	    // initial x,y
						    70*2,24*2,  // initial width, height
						    hwnd1,	    // handle to parent 
						    (HMENU)(100),	    // handle to menu
						    hCurrentInst,// instance of this application
						    NULL)))	// extra creation parms
	return(0);


	for (int i=0;i<8;i++)
		{
		CreateWindowEx(NULL,                  // extended style
		           "button",              // class
				    button_names[i], // title
	   				WS_CHILD | WS_VISIBLE | BS_AUTORADIOBUTTON,
					10,10+i*24,	  // initial x,y
					150,24,    // initial width, height
					hwnd1,	  // handle to parent 
					(HMENU)(101+i),	  // handle to menu
					hCurrentInst,  // instance of this application
					NULL);      // extra creation parms

		}

	while (!pois /*currchoice == 0*/) {
		if (PeekMessage(&msg,NULL,0,0,PM_REMOVE))
			{ 
			// test if this is a quit
			if (msg.message == WM_QUIT)
				break;
	
			 // translate any accelerator keys
				TranslateMessage(&msg);

			// send the message to the window proc
				DispatchMessage(&msg);
			} // end if
	       
	} // end while

	fullscreen = true;

	switch (currchoice)
		{
		case 1: XRES=640; YRES=480; break;
		case 2: XRES=800; YRES=600; break;
		case 3: XRES=960; YRES=720; break;
		case 4: XRES=1024; YRES=768; break;
		case 5: XRES=1152; YRES=864; break;
		case 6: XRES=1280; YRES=960; break;
		case 7: XRES=1280; YRES=1024; break;
		case 8: fullscreen = false; break;
		default: XRES=640; YRES=480; break;
		}

	//if (MessageBox (NULL, "fullscreen?", "^_^", MB_YESNO) == IDYES)
	//	fullscreen = true;

	if (fullscreen)
	{
		ChangeRes (XRES, YRES, 32, CDS_FULLSCREEN);
		hWnd = CreateWindow(
		CLASSNAME,													// Window class's name
		WINDOWNAME,													// Title bar text
		WS_POPUP | WS_MAXIMIZE | WS_CLIPCHILDREN | WS_CLIPSIBLINGS,	// Window style
		0, 0,														// Position
		XRES, YRES,													// Size
		NULL,														// Parent window's handle
		NULL,														// Menu handle
		hCurrentInst,												// Instance handle
		NULL );														// No additional data
		ShowCursor(FALSE);
	}
	else
	{
		hWnd = CreateWindow(
		CLASSNAME,													// Window class's name
		WINDOWNAME,													// Title bar text
		WS_OVERLAPPEDWINDOW | 
		WS_POPUP | WS_MAXIMIZE | WS_CLIPCHILDREN | WS_CLIPSIBLINGS,	// Window style
		0, 0,														// Position
		XRES, YRES,													// Size
		NULL,														// Parent window's handle
		NULL,														// Menu handle
		hCurrentInst,												// Instance handle
		NULL );														// No additional data
//		SetWindowPos (hWnd, HWND_TOPMOST, 0, 0, 0, 0, SWP_NOSIZE);
	}

	ShowWindow(hWnd, nCmdShow);
	UpdateWindow(hWnd);

	hDC = GetDC(hWnd);
	hDCFrontBuffer = hDC;
	if (!SetupPixelFormat(hDC))
		return 0;
	hGLRC = wglCreateContext(hDC);
	wglMakeCurrent(hDC, hGLRC);
	Init();

	while (GetMessage(&msg, NULL, 0, 0))
	{
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}
	ReleaseDC(hWnd, hDC);
	return msg.wParam;
}