#include "golden.h"
#include <windows.h>
#include <GL/gl.h>
#include <GL/glu.h>
#include <math.h>
#include "globals.h"
#include "system.h"
#include "text.h"
#include "keys.h"
#include "objgen.h"
//#include "nedata.h"
#include "tunnel.h"
extern unsigned char nedata[876];

Model *nelogosmodel, *nelogofloor, *tempp, *skysphere;

void generate_Golden()
{
nelogomodel->textured = true;
nelogomodel->texture = TID_ATG[1];
nelogomodel->scale(0.5,0.5,0.5);
nelogomodel->pX = -3.125;
nelogomodel->pZ = -3.375;
nelogomodel->pY = 0.11;

nelogosmodel = new Model;
nelogosmodel->textured = true;
nelogosmodel->texture = TID_ATG[1];
loadModel(*nelogosmodel,nedata,78,136);
//genCube(*nelogosmodel);
nelogosmodel->scale(0.52,0.52,0.52);
nelogosmodel->pX = -3.25;
nelogosmodel->pZ = -3.51;
//nelogosmodel->pY = -0.11;


//nelogofloor


nelogofloor = new Model;
nelogofloor->textured = true;
nelogofloor->texture = TID_ATG[0];
genTerrain(*nelogofloor,4,NULL,10);
nelogofloor->scale(10.0,0.0,10.0);

skysphere = new Model;
skysphere->textured = true;
skysphere->texture = TID_ATG[2];
genSphere(*skysphere,100.0,12,6,false);
skysphere->scale(0.5,0.5,0.5);
skysphere->pX = 0;



tempp = new Model;
tempp->textured = true;
tempp->texture = TID_ATG[4];
genCone(*tempp,12, 16.0, 0.3, 0.3);
tempp->scale(0.5,0.5,0.5);
tempp->pX = 0;

}


void init_Golden ()
{     /*
	GLfloat AmbientLight[] = { 0.85f, 0.85f, 0.65f, 1.0f };
	GLfloat DiffuseLight[] = { 1.0f, 1.0f, 0.65f, 1.0f };
	GLfloat LightPosition[] = { 0.0f, 10.0f, -1.0f, 1.0f };
*/
glEnable (GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA); 
	glEnable (GL_TEXTURE_2D);
	glDisable (GL_DEPTH_TEST);
	glBindTexture (GL_TEXTURE_2D, TID_LOGO);


	GLfloat AmbientLight[] = { 0.75f, 0.75f, 0.75f, 1.0f };
	GLfloat DiffuseLight[] = { 1.0f, 1.0f, 1.0f, 1.0f };
	GLfloat LightPosition[] = { 0.0f, 100.0f, 100.0f, 1.0f };

	glLightfv(GL_LIGHT1, GL_AMBIENT, AmbientLight);
	glLightfv(GL_LIGHT1, GL_DIFFUSE, DiffuseLight);
	glLightfv(GL_LIGHT1, GL_POSITION, LightPosition); 
	
	//glDisable (GL_LIGHT0);
	glEnable (GL_LIGHT1);
	glEnable (GL_LIGHTING);
	glDisable (GL_BLEND);
	glDisable (GL_TEXTURE_GEN_T);
	glDisable (GL_TEXTURE_GEN_S);
	
	glDisable (GL_FOG);
	/*
	glFogf (GL_FOG_START, 50.0);
	glFogf (GL_FOG_END, 100.0);
	GLfloat fogCol[4] = { 0.0f, 0.0f, 0.0f, 1.0f };
	glFogfv (GL_FOG_COLOR, fogCol);
	*/

	glEnable (GL_DEPTH_TEST);
	glClearColor (0.0f, 0.0f, 0.0f, 1.0f);
	glEnable (GL_CULL_FACE);
	glCullFace (GL_BACK);
	glEnable (GL_TEXTURE_2D);

	fov = 60;

	cam.directional = false;
	cam.tgt[0] = 0;
	cam.tgt[1] = 3;
	cam.tgt[2] = 0;
}








void part_Goldenpart ()
{
	static float starttime = time;
	static float lasttime = 0;
	float lapsedtime = time - starttime;
	float delta = lapsedtime - lasttime;

	static float fa = 0.0;
	static float dist = 20.0f;
		
	init_Golden ();
		
	//anim_templewater(*templewater1);

	float stime = time*sin(3.14*time/23);

	dist = 15 -( sin(3.14*time/400)*10* cos(3.14*time/4) );

	cam.pos[0] = (GLfloat)sin(3.14*time/7)*dist;
	cam.pos[1] = 1;//fabs(sin(3.14*stime/37)*10*(GLfloat)cos(3.14*stime/17));
	cam.pos[2] = (GLfloat)cos(3.14*time/7)*dist;

	SetProjection ();

	glFrontFace (GL_CW);

	skysphere->render ();
	
	glFrontFace (GL_CCW);

	
	nelogomodel->render ();

	glEnable (GL_TEXTURE_GEN_T);
	glEnable (GL_TEXTURE_GEN_S);
	
	glEnable (GL_BLEND);
	nelogosmodel->render ();
	glDisable (GL_BLEND);

	
	glFrontFace (GL_CW);

	glPushMatrix();
		glScalef(1.0, -1.0, 1.0);
		glTranslatef (0.0f, 0.0, 0.0);
		nelogomodel->render ();
	glPopMatrix();
	
	glFrontFace (GL_CCW);
	
	glDisable (GL_TEXTURE_GEN_T);
	glDisable (GL_TEXTURE_GEN_S);

	glEnable (GL_BLEND);
	nelogofloor->render ();
	glDisable (GL_BLEND);

	if (mtime > 18.0)
	{
		ledsensmiley (0, 0, 0, fa);
		fa += delta * 0.33;
	}

	
	lasttime = lapsedtime;
}
