#ifndef __MODEL_H
#define __MODEL_H

#define		MESH_TRI	1
#define		MESH_QUAD	2

#include "vector.h"

struct TCoords
{
	GLfloat u, v;
};

struct Vertex
{
	GLfloat x, y, z;
	GLfloat r, g, b, a;
	CVector n;
	int		num;
};

struct Triangle
{
	Vertex	*v[3];
	TCoords	uv[3];
	CVector	n;
};

struct Quad
{
	Vertex	*v[4];
	TCoords	uv[4];
	CVector	n;
};


class Model
{
   protected:
   public:
	   Vertex		*vertex;
	   Triangle		*triangle;
	   Quad			*quad;

	   int			nVertices,
					nPrimitives;
	   int			state;
	   int			texture;
	   int			meshtype;

	   bool			loadedNormals;
	   bool			textured;
	   bool			visible;

	   GLfloat		rX, rY, rZ;
	   GLfloat		pX, pY, pZ;
	   GLfloat		sX, sY, sZ;

	   Model (int mesh = MESH_TRI, int numVtx = 0, int numTris = 0);
	   ~Model ();
	   void calcNormals ();
	   void render ();
	   void resize (int numVtx, int numTris);
	   void loadCAS (char *filename);
	   void scale( GLfloat x, GLfloat y, GLfloat z ) { sX = x; sY = y; sZ = z; }
	   void setpos( GLfloat x, GLfloat y, GLfloat z ) { pX = x; pY = y; pZ = z; }
};

#endif