#include <windows.h>
#include <gl/gl.h>
#include <gl/glu.h>


WINGDIAPI void APIENTRY wglSwapBuffers(int);
WINGDIAPI void APIENTRY wglSetPixelFormat(int,int,int);


GLUquadricObj *quad;

void main()
{ 
	HDC hdc;
	HWND w;
	HGLRC hglrc; 
	float t;


 	w = CreateWindowEx(WS_EX_TOPMOST,"EDIT","EDIT",WS_VISIBLE+WS_POPUP,0,0,
			   GetSystemMetrics(SM_CXSCREEN),GetSystemMetrics(SM_CYSCREEN),
			   0,0,0,0);
	hdc = GetDC(w);

	SetPixelFormat(hdc,4,0);
	hglrc = wglCreateContext(hdc); 
	wglMakeCurrent(hdc,hglrc);

	glMatrixMode(GL_PROJECTION);
	gluPerspective(100.,1.,1.,100.);
	glMatrixMode(GL_MODELVIEW);

	glEnable(GL_BLEND);
	glEnable(GL_TEXTURE_2D);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	glColor4f(1,1,1,.06);

	gluBuild2DMipmaps(GL_TEXTURE_2D,4,16,16,GL_RGBA,GL_UNSIGNED_BYTE,&main);

	quad = gluNewQuadric();
	gluQuadricTexture(quad,GL_TRUE);


	//here i did't use GetMessage(), so here is no sync
	while(!GetAsyncKeyState(VK_ESCAPE)){
		glLoadIdentity();

		glRotatef(t,1,0,0);
		glRotatef(t,0,1,1);
		glRotatef(t,0,0,1);
		gluSphere(quad,100,10,10);

		t += 0.3;
		wglSwapBuffers(hdc);
	}

	wglMakeCurrent(0,0);
	wglDeleteContext(hglrc); 
}



