
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>


#define SRATE   44100
#define Ta      ( 1.0f / SRATE )

#define M_PI    3.141592654f
#define sqr(a)  ( (a)*(a) )
#define exp2(x)	( pow( 2.0, x * 1.442695041 ) )

typedef struct {                // digital designed 12dB IIR resonator

        float  a, b, c;     // filter vars, coeff's
        float  y, z1, z2;     // (2 pole, 12 dB)

} T_BP;

T_BP		bp[ 2 ];


void bp_init( T_BP &bp, float f, float bw ) {

	float r = exp2( -M_PI*bw*Ta );
        bp.c = - r*r;
        bp.b = r * 2.0f * cos( 2.0f*M_PI*f*Ta );
	bp.a = 1.0f - bp.b - bp.c;

}

void bp_iir( T_BP &bp, float in ) {	// 12 dB bi-quad

        bp.y = bp.a*in + bp.b*bp.z1 + bp.c*bp.z2;
        bp.z2 = bp.z1;
        bp.z1 = bp.y;

}

void main() {

	FILE *in = fopen( "input", "r" );
	FILE *f = fopen( "out.smp", "wb" );
	FILE *d = fopen( "fmt.bin", "wb" );

        memset( &bp, 0, sizeof bp );

	float	fm1 = 0.0f, fm2 = 0.0f,
		bw1 = 0.0f, bw2 = 0.0f,
		am1 = 0.0f, am2 = 0.0f,
		as = 0.0f, saw = 0.0f, mul;

	while ( !feof( in ) ) {

		int f1,f2,b1,b2,a1,a2,asp, len;

		fscanf(in, "%d", &f1 );
		if ( f1 < 0 ) break;
                fscanf(in, "%d", &f2 );
                fscanf(in, "%d", &b1 );
                fscanf(in, "%d", &b2 );
                fscanf(in, "%d", &a1 );
                fscanf(in, "%d", &a2 );
                fscanf(in, "%d", &asp );
		fscanf(in, "%d", &len );
		char bla[256];
		fscanf(in, "%s", &bla);

		// quantisation
		int ff1 = f1 * 255 / 3500;
		int ff2 = f2 * 255 / 3500;
		int flen = len * 255 / 65536;

  //              printf("%d %d %d %d %d %d %d %d %d %d %d\n", f1,f2,b1,b2,a1,a2,asp,len );
//                printf("%f %f %f %f %f %f %f %f %f %f\n", fm1,fm2,bw1,bw2,am1,am2,as );

		// write formant data
		fputc( ff1, d );
		fputc( ff2, d );
		fputc( b1, d );
		fputc( b2, d );
		fputc( a1, d );
		fputc( a2, d );
		fputc( asp, d );
		fputc( flen, d );

		bw1 = 50; bw2 = 150;

		// write wave data
		for ( int i=0; i<len; i++ ) {

			if ( asp ) mul = 1.0f; else mul=1.0f/512.0f;

                        fm1 += ( f1 - fm1 ) * mul;
                        fm2 += ( f2 - fm2 ) * mul;
                        bw1 += ( b1 - bw1 ) * mul;
                        bw2 += ( b2 - bw2 ) * mul;
                        am1 += ( a1 - am1 ) * mul;
                        am2 += ( a2 - am2 ) * mul;
                        as += ( asp - as ) * mul;

                        bp_init( bp[0], fm1, bw1 );
                        bp_init( bp[1], fm2, bw2 );

                        saw += 90.0f/44100.0f - (int)saw;

                        double src = (saw - .5f)*(1.0f-as/256.0f) + as/256.0f * ( (rand() & 255) / 256.0f - 0.5f);

                        bp_iir( bp[0], src * am1 );
                        bp_iir( bp[1], src * am2 );

                        float out = bp[0].y + bp[1].y;

                        char s = out * 0.3f;
                        fputc( s, f );

		}

	}

	fcloseall();

}

