# Ŀ
#                    Mystic-MOD - Mystic BBS Modification                    
# Ĵ
#   Title                         File Request (FRequest) v8                 
#   Author                        zoob                                       
#   Version of Mystic Required    v1.05+                                     
# Ĵ
#                                Release Type                                
# Ĵ
#   [ ] Art  [ ] BBS Mod  [ ] BBS Util  [x] MPE Script  [ ] _______________  
# Ĵ
#                                  Comments                                  
# Ĵ
#   Features                                                                 
#   ~~~~~~~~                                                                 
#   * Configurable colour schemes                                            
#   * 'Search' function                                                      
#   * Allows for each languages' colour schemes                              
#   * Includes SysOp functions such as:                                      
#     * Entry reviewing                                                      
#     * Purging of entries                                                   
#   * Easy to use                                                            
#   * Uses Mystic's internal MPE engine so no shelling is needed!            
# Ĵ
#                                Installation                                
# Ĵ
#   1. Move ZO-FREQ.MPS to your \SCRIPTS directory                           
#   2. Edit your menus to run GX and have ZO-FREQ <colour> in the data       
#      <colour> being:                                                       
#      blue, green, cyan, red, magenta, yellow or grey                       
#      This is the colour scheme that will be used in the display            
#   3. Compile ZO-FREQ.MPS                                                   
#   4. Configure for all your lanuages                                       
#   6. Move *.ASC into your \TEXT directory                                  
#   7. Enjoy!                                                                
# Ĵ
#                                What's New?                                 
# Ĵ
#   * Some misc internal changes                                             
# Ĵ
#                                Other Stuff                                 
# Ĵ
#   Special thanks to James Coyle for some stuff he mentioned to me..        
#                                                                            
#   I found a bunch of bugs in Mystic while writing this script, and I also  
#   wrote some MPL documentation for the next release!                       
#                                                                            
#   Upcoming features                                                        
#   ~~~~~~~~~~~~~~~~~                                                        
#   * SysOp Menu: Search (?)                                                 
# Ĵ
#                               Contacting Me                                
# Ĵ
#   Want to send comments, flames, suggestions or death threats?             
#                                                                            
#   Email: zoob@telebot.net                                                  
#   Web  : http://www.darktech.org/zoob                                      
# 
#
# ---------------------------------------------------------------------------
# ZO-FREQ  .MPS : File Requester (FRequest) v8 by zoob
# ---------------------------------------------------------------------------
# (C) Copyright 1999 By zoob.  All Rights Reserved.
# ---------------------------------------------------------------------------
# Feel free to modify this, but give credit to me if you rerelease it.
# ---------------------------------------------------------------------------

Uses USER
Uses CFG

# Constants
Var Bar       String    # Big long bar
Var File1     String    # ZO-FREQ.BIN
Var File2     String    # ZO-FREQ.~~~

# Various string variables =)
Var Inpt      String
Var S         String
Var ShowLine1 String
Var ShowLine2 String
Var Count     Byte
Var Count2    Byte
Var NOS       Byte
Var Done      Boolean
Var fpos      longint
Var Entry     LongInt
Var Temp      Integer
Var SavedX    Byte
Var More      Boolean

# Colour schemes
Var C1        String
Var C2        String
Var C3        String

# Record Variables
Var User String
Var Desc String

# B E G I N  C O D E

### Show version information
Proc ShowInfo
  Cls
  WriteLn('|CR'+C1+'F'+C2+'R'+C3+'equest v8 by zoob')
  WriteLn(C1+'-'+C2+'-'+C3+'------------------'+C2+'-'+C1+'-|CR')
PEnd ShowInfo

Proc ShowLine
  writeln(ShowLine1+User)
  writeln(ShowLine2+Desc)
PEnd ShowLine

Proc MoreYN
  SavedX := WhereX
  Write(c1+'m'+c2+'o'+c3+'re? [Yn] ')
  Inpt := ReadKey
  If Upper(inpt) = 'N' then
    More := False
  Else
    More := True
  EndIf
  MoveX(SavedX)
  Write('           ')
  MoveX(SavedX)
PEnd MoreYN

### Request procedure
Proc Request
  If InputNY('|CR'+C1+'d'+C2+'o'+C3+' you want to request a file? ')
    Cls
    WriteLn(C1+'e'+C2+'n'+C3+'ter the description of the file')
    Write(C3+': ')
    Desc := Input(70, 70, 1, '')
    If Desc <> ''
      If FExist(file1)
          FOpen(1, Bin, Append, file1)
        Else
          FOpen(1, Bin, Rewrite, file1)
      EndIf
      user := lower(useralias)
      fwriterec(1,user,30)
      fwriterec(1,desc,70)
      FClose(1)
    EndIf
  EndIf
PEnd Request

### View requests
Proc View
  If InputNY('|CR'+C1+'d'+C2+'o'+C3+' you want to view the file request list? ')
    ShowInfo
    If Not FExist(file1)
        WriteLn(C1+'n'+C2+'o'+C3+' entries available')
        Write('|CR|PA')
      Else
        Count := 0
        FOpen(1, Bin, Reset, file1)
        More := True
        Repeat
          If Count = 0
              WriteLn(Bar)
              NOS := NOS + 1
              If NOS = 5
                  NOS := 1
                  MoreYN
              EndIf
            ElseIf Count = 1
              FReadRec(1, User, 30)
              FReadRec(1, Desc, 70)
              ShowLine
          EndIf
          Count := Count + 1
          If Count = 2 Count := 0 EndIf
        Until EOF(1) or More=False
        FClose(1)
        If More=True Then WriteLn(Bar) EndIf
        Write('|CR|PA')
    EndIf
  EndIf
PEnd View

### Search function
Proc Search
  If InputNY('|CR'+C1+'d'+C2+'o'+C3+' you want to search for text? ')
    ShowInfo
    Count2 := 0
    Count := 0
    WriteLn(c1+'e'+c2+'n'+C3+'ter text '+c2+': '+C3)
    Inpt := Input(70, 70, 1, '')
    if inpt<>''
      If Not FExist(file1)
          WriteLn(c1+'n'+c2+'o'+C3+' entries available')
          Write('|CR|PA')
        Else
          FOpen(1, Bin, Reset, file1)
          More := True
          Repeat
            FReadRec(1, S, 30)
            FReadRec(1, S, 70)
            If Pos(Upper(Inpt), Upper(S)) > 0
                Count2 := Count2 + 1
                fseek(1, filepos(1)-102)
                FReadRec(1, User, 30)
                FReadRec(1, Desc, 70)
                WriteLn(Bar)
                ShowLine
                NOS := NOS + 4
                If NOS = 16
                    MoreYN
                EndIf
            EndIf
          Until EOF(1) Or More=False
          WriteLn(Bar)
          FClose(1)
          If Count2 = 0
              WriteLn(C1+'n'+C2+'o'+C3+' entries containing:')
              WriteLn(Inpt)
              WriteLn(Bar)
          EndIf
          Write('|PA')
      EndIf
    endif
  EndIf
PEnd Search

Var FO Boolean

### Review entries
Proc Remove
    FO := False
  Entry := 1
  Repeat
    Done := False
    ShowInfo
    WriteLn(C1+'r'+c2+'e'+c3+'view entries|CR')
        WriteLn(bar)
    If Not FExist(file1)
        WriteLn(c1+'n'+c2+'o'+C3+' entries available')
        WriteLn(bar)
        Write('|CR|PA')
        Done := True
      Else
        If Not FO
            If Not FCopy(File1, File2)
                Repeat
                  Delay(10)
                Until FCopy(File2, File1)
            EndIf
            FOpen(2, Bin, Reset, cfgdatapath+'zo-freq.~~~')
            FO := True
        EndIf
        If EOF(2)
            FSeek(2,0)
        EndIf
        entry := filepos(2)/102 +1
        nos := filesize(2)/102
        WriteLn(C1+'e'+c2+'n'+c3+'try'+c2+': '+c3+Entry+c2+'/'+c3+nos)
        FReadRec(2, User, 30)
        FReadRec(2, Desc, 70)
        ShowLine
        WriteLn(bar)
        FSeek(2, FilePos(2)-102)
        WriteLn('|CR'+c1+'['+c2+' back  '+c1+']'+c2+' foward  '+c1+'d'+c2+' delete  '+c1
        +'e'+c2+' edit  '+c1+'j'+c2+' jump  '+c1+'q'+c2+' quit')
        Inpt := ReadKey
        If Upper(Inpt) = '['
            fpos:=filepos(2)-124
            If FPos<0
                FSeek(2,0)
              else
                FSeek(2, filepos(2)-102)
            endif
          Elseif Upper(Inpt) = ']'
            FPos:=FilePos(2)+102
            If FPos=FileSize(2)
                FSeek(2, FilePos(2))
              Else
                FSeek(2, FilePos(2)+102)
            EndIf
          Elseif Upper(Inpt) = 'J'
            Write('|CR'+c1+'j'+c2+'u'+c3+'mp to entry '+c2+': '+c3)
            Inpt := Input(3, 3, 1, '')
            Temp := Str2Int(Inpt)
            NOS := FileSize(2) / 102 +1
            If Temp > 0 Then
              If Temp < NOS Then
                FSeek(2, Temp * 102 - 102)
              EndIf
            EndIf
          Elseif Upper(Inpt) = 'E'
            Write('|CR'+ShowLine1)
            User := Input(30, 30, 1, User)
            Write('|CR'+ShowLine2)
            Desc := Input(70, 70, 1, Desc)
            If Desc <> '' and User <> ''
                FSeek(2, FilePos(2))
                FWriteRec(2, User, 30)
                FWriteRec(2, Desc, 70)
            EndIf
            FSeek(2, FilePos(2) - 102)
          Elseif Upper(Inpt) = 'D'
            If Not InputNY('|CR'+c1+'d'+c2+'e'+c3+'lete entry? ')
              Else
                fpos := filepos(2)
                fopen(3,bin,rewrite,'zo-freq.del')
                fseek(2,0)
                count := 0
                if entry = 1
                    writeln('|CR'+c1+'c'+c2+'a'+c3+'nnot delete last entry.  purge instead.')
                    Write('|CR|PA')
                  else
                    repeat
                      freadrec(2, user, 30)
                      freadrec(2, desc, 70)
                      count := count + 1
                      if count = entry
                        else
                          fwriterec(3, user, 30)
                          fwriterec(3, desc, 70)
                      endif
                    until eof(2)
                    fclose(3)
                    fclose(2)
                    If Not FCopy('zo-freq.del', File2)
                        Repeat
                          Delay(10)
                        Until FCopy(File2, File1)
                    EndIf
                    fopen(2, bin, reset, file2)
                    fseek(2, fpos-102)
                EndIf
            endif
          ElseIf Upper(Inpt) = 'Q'         
            Done := True
            fclose(2)
            If InputYN('|CR'+C1+'s'+c2+'a'+c3+'ve before quitting? ')
              If Not FCopy(File2, File1)
                  Repeat
                    Delay(10)
                  Until FCopy(File2, File1)
              EndIf
            EndIf
        EndIf
    EndIf
  Until Done
  Done := False
  ferase(file2)
PEnd Remove

### SysOp menu
Proc SMenu
  Repeat
  Done := False
  NOS := 0
  dispFile(CfgTextPath + 'zo-frqop')
  Inpt := ReadKey
  If Upper(Inpt) = 'Q'
      Done := True
    Elseif Upper(Inpt) = 'P'
      If InputNY('|CR'+C1+'d'+C2+'o'+C3+' you want to purge the database? ')
        FErase(file1)
        Else
      EndIf
    Elseif Upper(Inpt) = 'R'
      Remove
    Elseif Upper(Inpt) = 'S'
      Search
    Elseif Upper(Inpt) = 'V'
      View
  EndIf
  Until Done
PEnd SMenu

### Main menu
Proc Menu
  NOS := 0
  if acs('s255')
      dispFile(CfgTextPath + 'zo-frqm1')
  elseif fExist(CfgTextPath + 'zo-frqm0.asc')
    dispFile(CfgTextPath + 'zo-frqm0')
  endif
  Inpt := ReadKey
  If Upper(Inpt) = 'Q'
    If InputYN('|CR'+C1+'d'+C2+'o'+C3+' you want to exit? ') Then
        Halt
    EndIf
    Elseif Upper(Inpt) = 'R'
      Request
    Elseif Upper(Inpt) = 'V'
      View
    Elseif Upper(Inpt) = 'S'
      Search
    Elseif Upper(Inpt) = '*'
      If UserSec = 255 SMenu EndIf
  EndIf
PEnd Menu

# Setup variables
GetCFG

File1 := cfgdatapath+'zo-freq.bin'
File2 := cfgdatapath+'zo-freq.~~~'

C3 := '|08'
If Upper(ParamStr(1))='BLUE'
    c2 :='|01'
    c1 :='|09'
  ElseIf Upper(ParamStr(1))='GREEN'
    c2 :='|02'
    c1 :='|10'
  ElseIf Upper(ParamStr(1))='CYAN'
    c2 :='|03'
    c1 :='|11'
  ElseIf Upper(ParamStr(1))='RED'
    c2 :='|04'
    c1 :='|12'
  ElseIf Upper(ParamStr(1))='MAGENTA'
    c2 :='|05'
    c1 :='|13'
  ElseIf Upper(ParamStr(1))='YELLOW'
    c2 :='|06'
    c1 :='|14'
  ElseIf Upper(ParamStr(1))='GREY'
    c2 :='|07'
    c1 :='|15'
  Else
    c2 := '|01'
    c1 := '|09'
EndIf

ShowLine1 := C1+'u'+C2+'s'+C3+'er '+C2+': '+C3
ShowLine2 := C1+'d'+C2+'e'+C3+'sc '+C2+': '+C3
Bar       := C3+'|$D79'
NOS := 0

GetThisUser

# Main loop
Repeat
  Menu
Until Inpt = 'Q'
